/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey.activity;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.ActivitySnapshot;
import io.bdeploy.common.NoThrowAutoCloseable;
import io.bdeploy.common.security.RemoteService;
import io.bdeploy.common.util.JacksonHelper;
import io.bdeploy.common.util.UuidHelper;
import io.bdeploy.jersey.JerseyRequestContext;
import io.bdeploy.jersey.JerseyScopeService;
import io.bdeploy.jersey.activity.JerseyRemoteActivity;
import io.bdeploy.jersey.activity.JerseyRemoteActivityProxy;
import io.bdeploy.jersey.activity.JerseyRemoteActivityScopeServerFilter;
import io.bdeploy.jersey.ws.change.ObjectChangeBroadcaster;
import io.bdeploy.jersey.ws.change.msg.ObjectChangeDto;
import io.bdeploy.jersey.ws.change.msg.ObjectEvent;
import io.bdeploy.jersey.ws.change.msg.ObjectScope;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class JerseyBroadcastingActivityReporter
implements ActivityReporter {
    public static final String OCT_ACTIVIES = "ACTIVITIES";
    private static final String CURRENT_ACTIVITY = "CURRENT_ACTIVITY";
    private static final Logger log = LoggerFactory.getLogger(JerseyBroadcastingActivityReporter.class);
    private static final List<JerseyRemoteActivity> globalActivities = new CopyOnWriteArrayList<JerseyRemoteActivity>();
    private static final Set<ObjectScope> activeScopes = new TreeSet<ObjectScope>();
    @Inject
    private JerseyScopeService jss;
    @Inject
    @Optional
    private ObjectChangeBroadcaster bc;
    @Inject
    private JerseyRequestContext reqCtx;

    @Inject
    public JerseyBroadcastingActivityReporter(@Named(value="BcExecutor") ScheduledExecutorService scheduler) {
        scheduler.scheduleAtFixedRate(this::sendUpdate, 1L, 1L, TimeUnit.SECONDS);
    }

    private void sendUpdate() {
        if (this.bc == null) {
            return;
        }
        try {
            List<ActivitySnapshot> list = this.getGlobalActivities().stream().filter(Objects::nonNull).map(JerseyRemoteActivity::snapshot).collect(Collectors.toList());
            List scopes = list.stream().map(a -> new ObjectScope(a.scope)).distinct().collect(Collectors.toList());
            HashMap perScope = new HashMap();
            for (Iterator scope : scopes) {
                ArrayList<ActivitySnapshot> forScope = new ArrayList<ActivitySnapshot>();
                for (ActivitySnapshot snapshot : list) {
                    if (snapshot.parentUuid != null || !((ObjectScope)((Object)scope)).matches(new ObjectScope(snapshot.scope))) continue;
                    forScope.add(snapshot);
                    while (this.addChildren(forScope, list) != 0) {
                    }
                }
                if (forScope.isEmpty()) continue;
                perScope.put(scope, forScope);
            }
            activeScopes.addAll(perScope.keySet());
            ArrayList<ObjectScope> scopesToRemove = new ArrayList<ObjectScope>();
            for (ObjectScope active : activeScopes) {
                if (perScope.containsKey(active)) continue;
                scopesToRemove.add(active);
            }
            for (ObjectScope toRemove : scopesToRemove) {
                activeScopes.remove(toRemove);
                this.bc.send(new ObjectChangeDto(OCT_ACTIVIES, toRemove, ObjectEvent.CHANGED, Collections.singletonMap(OCT_ACTIVIES, "[]")));
            }
            ArrayList<ObjectChangeDto> allMessages = new ArrayList<ObjectChangeDto>();
            for (Map.Entry e : perScope.entrySet()) {
                allMessages.add(new ObjectChangeDto(OCT_ACTIVIES, (ObjectScope)e.getKey(), ObjectEvent.CHANGED, Collections.singletonMap(OCT_ACTIVIES, this.serialize((List)e.getValue()))));
            }
            this.bc.sendBestMatching(allMessages);
        }
        catch (Exception e) {
            log.error("Error while broadcasting activities", e);
        }
    }

    private String serialize(List<ActivitySnapshot> snap) {
        try {
            return JacksonHelper.getDefaultJsonObjectMapper().writeValueAsString(snap);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Cannot serialize activities", e);
        }
    }

    private int addChildren(List<ActivitySnapshot> activities, List<ActivitySnapshot> pool) {
        Set haveUuids = activities.stream().map(s2 -> s2.uuid).collect(Collectors.toCollection(TreeSet::new));
        ArrayList<ActivitySnapshot> children = new ArrayList<ActivitySnapshot>();
        for (ActivitySnapshot root : activities) {
            for (ActivitySnapshot potentialChild : pool) {
                if (haveUuids.contains(potentialChild.uuid) || potentialChild.parentUuid == null || !potentialChild.parentUuid.equals(root.uuid)) continue;
                children.add(potentialChild);
            }
        }
        activities.addAll(children);
        return children.size();
    }

    @Override
    public ActivityReporter.Activity start(String activity) {
        return this.start(activity, -1L);
    }

    @Override
    public ActivityReporter.Activity start(String activity, long maxWork) {
        return this.start(activity, () -> maxWork, null);
    }

    @Override
    public synchronized ActivityReporter.Activity start(String activity, LongSupplier maxValue, LongSupplier currentValue) {
        List<String> scope = JerseyRemoteActivityScopeServerFilter.getRequestActivityScope(this.jss);
        String user = this.jss.getUser();
        JerseyRemoteActivity parent = this.getCurrentActivity();
        String parentUuid = null;
        if (parent != null) {
            parentUuid = parent.getUuid();
        }
        JerseyRemoteActivity act = new JerseyRemoteActivity(this::done, null, activity, maxValue, currentValue, scope, user, System.currentTimeMillis(), UuidHelper.randomId(), parentUuid);
        if (log.isTraceEnabled()) {
            log.trace("Begin: [{}] {}", (Object)act.getUuid(), (Object)activity);
        }
        this.setCurrentActivity(act);
        globalActivities.add(act);
        return act;
    }

    private synchronized void done(JerseyRemoteActivity act) {
        if (!globalActivities.contains(act)) {
            return;
        }
        JerseyRemoteActivity current = this.getCurrentActivity();
        if (current != null && current.getUuid().equals(act.getUuid())) {
            if (act.getParentUuid() != null) {
                JerseyRemoteActivity parent = this.getActivityById(act.getParentUuid());
                if (parent != null) {
                    this.setCurrentActivity(parent);
                } else {
                    log.warn("Parent activity no longer available: {} for {}", (Object)act.getParentUuid(), (Object)act);
                }
            } else {
                this.resetCurrentActivity();
            }
        } else if (current != null) {
            log.warn("Finished activity is not current for this thread: {}, current: {}", (Object)act, (Object)current);
        } else {
            log.warn("Finished activity but there is no current activity for this thread: {}", (Object)act);
        }
        globalActivities.remove(act);
    }

    @Override
    public NoThrowAutoCloseable proxyActivities(RemoteService service) {
        return new JerseyRemoteActivityProxy(service, this);
    }

    synchronized List<JerseyRemoteActivity> getGlobalActivities() {
        return new ArrayList<JerseyRemoteActivity>(globalActivities);
    }

    synchronized void addProxyActivity(JerseyRemoteActivity act) {
        globalActivities.add(act);
    }

    synchronized void removeProxyActivity(JerseyRemoteActivity act) {
        globalActivities.remove(act);
    }

    JerseyRemoteActivity getCurrentActivity() {
        return (JerseyRemoteActivity)this.reqCtx.getProperty(CURRENT_ACTIVITY);
    }

    void setCurrentActivity(JerseyRemoteActivity act) {
        this.reqCtx.setProperty(CURRENT_ACTIVITY, act);
    }

    void resetCurrentActivity() {
        this.reqCtx.removeProperty(CURRENT_ACTIVITY);
    }

    JerseyRemoteActivity getActivityById(String uuid) {
        return globalActivities.stream().filter(Objects::nonNull).filter(a -> a.getUuid().equals(uuid)).findAny().orElse(null);
    }
}

