/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey.activity;

import io.bdeploy.common.ActivitySnapshot;
import io.bdeploy.common.NoThrowAutoCloseable;
import io.bdeploy.common.security.RemoteService;
import io.bdeploy.common.util.JacksonHelper;
import io.bdeploy.common.util.UuidHelper;
import io.bdeploy.jersey.JerseyClientFactory;
import io.bdeploy.jersey.activity.JerseyBroadcastingActivityReporter;
import io.bdeploy.jersey.activity.JerseyRemoteActivity;
import io.bdeploy.jersey.ws.change.client.ObjectChangeClientWebSocket;
import io.bdeploy.jersey.ws.change.msg.ObjectChangeDto;
import io.bdeploy.jersey.ws.change.msg.ObjectScope;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JerseyRemoteActivityProxy
implements NoThrowAutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(JerseyRemoteActivityProxy.class);
    private final String proxyUuid;
    private final JerseyBroadcastingActivityReporter reporter;
    private final RemoteService remote;
    private final JerseyRemoteActivity parent;
    private final Map<String, ActivityNode> proxiedActivities;
    private final Map<String, String> uuidMapping;
    private ObjectChangeClientWebSocket ws;

    public JerseyRemoteActivityProxy(RemoteService service, JerseyBroadcastingActivityReporter reporter) {
        block3: {
            this.proxyUuid = "proxy-" + UuidHelper.randomId();
            this.proxiedActivities = new TreeMap<String, ActivityNode>();
            this.uuidMapping = new TreeMap<String, String>();
            if (service.getKeyStore() == null) {
                throw new IllegalStateException("RemoteService references a local service: " + service.getUri());
            }
            this.reporter = reporter;
            this.parent = reporter.getCurrentActivity();
            this.remote = service;
            try {
                this.ws = JerseyClientFactory.get(service).getObjectChangeWebSocket(this::onMessage);
                this.ws.subscribe("ACTIVITIES", new ObjectScope(this.proxyUuid));
                JerseyClientFactory.setProxyUuid(this.proxyUuid);
            }
            catch (Exception e) {
                this.ws = null;
                log.warn("Cannot proxy remote activities: {}", (Object)e.toString());
                if (!log.isDebugEnabled()) break block3;
                log.debug("Exception", e);
            }
        }
    }

    private synchronized void onMessage(ObjectChangeDto change) {
        List<ActivitySnapshot> activities;
        try {
            String serialized = change.details.get("ACTIVITIES");
            activities = JacksonHelper.getDefaultJsonObjectMapper().readValue(serialized, ActivitySnapshot.LIST_TYPE);
        }
        catch (IOException e) {
            log.error("Cannot read activities");
            if (log.isDebugEnabled()) {
                log.debug("Exception:", e);
            }
            return;
        }
        for (ActivitySnapshot snap : activities) {
            String mappedParentUuid;
            if (snap.scope == null || snap.scope.isEmpty() || !snap.scope.get(0).equals(this.proxyUuid)) continue;
            String mappedUuid = this.uuidMapping.computeIfAbsent(snap.uuid, s2 -> UuidHelper.randomId());
            String string = mappedParentUuid = snap.parentUuid == null ? null : this.uuidMapping.computeIfAbsent(snap.parentUuid, s2 -> UuidHelper.randomId());
            if (this.proxiedActivities.containsKey(mappedUuid)) {
                this.updateExistingActivity(snap, mappedUuid);
                continue;
            }
            this.createNewActivity(snap, mappedUuid, mappedParentUuid);
        }
        this.cleanupActivities(activities);
    }

    private void cleanupActivities(List<ActivitySnapshot> activities) {
        Set reportedUuids = activities.stream().map(a -> this.uuidMapping.get(a.uuid)).collect(Collectors.toSet());
        TreeSet<String> toRemove = new TreeSet<String>();
        for (Map.Entry<String, ActivityNode> entry : this.proxiedActivities.entrySet()) {
            if (reportedUuids.contains(entry.getKey())) continue;
            entry.getValue().activity.done();
            toRemove.add(entry.getKey());
        }
        toRemove.forEach(this.proxiedActivities::remove);
    }

    private void createNewActivity(ActivitySnapshot snap, String mappedUuid, String mappedParentUuid) {
        String parentUuid = mappedParentUuid;
        if (parentUuid == null || !this.hasGlobalActivity(parentUuid)) {
            parentUuid = this.parent == null ? null : this.parent.getUuid();
        }
        ActivityNode node = new ActivityNode(snap, this.parent, this::onDone, this::onCancel, mappedUuid, parentUuid);
        this.proxiedActivities.put(mappedUuid, node);
        this.reporter.addProxyActivity(node.activity);
    }

    private void updateExistingActivity(ActivitySnapshot snap, String mappedUuid) {
        ActivityNode toUpdate = this.proxiedActivities.get(mappedUuid);
        toUpdate.current = snap.current;
        toUpdate.max = snap.max;
        if (snap.cancel) {
            toUpdate.activity.requestCancel();
        }
    }

    private boolean hasGlobalActivity(String uuid) {
        return this.reporter.getActivityById(uuid) != null;
    }

    private void onDone(JerseyRemoteActivity activity) {
        this.reporter.removeProxyActivity(activity);
    }

    private void onCancel(JerseyRemoteActivity activity) {
        String actualUuid = this.uuidMapping.entrySet().stream().filter(e -> ((String)e.getValue()).equals(activity.getUuid())).findFirst().map(Map.Entry::getKey).orElse(null);
        if (actualUuid == null) {
            return;
        }
        JerseyClientFactory.get(this.remote).getBaseTarget(new Object[0]).path("/activities/" + actualUuid).request().delete();
    }

    @Override
    public void close() {
        JerseyClientFactory.setProxyUuid(null);
        for (Map.Entry<String, ActivityNode> entry : this.proxiedActivities.entrySet()) {
            entry.getValue().activity.done();
        }
        if (this.ws != null) {
            this.ws.close();
        }
    }

    private static class ActivityNode {
        public JerseyRemoteActivity activity;
        public long current = 0L;
        public long max = -1L;

        public ActivityNode(ActivitySnapshot snapshot, JerseyRemoteActivity root, Consumer<JerseyRemoteActivity> onDone, Consumer<JerseyRemoteActivity> onCancel, String uuid, String parentUuid) {
            this.current = snapshot.current;
            this.max = snapshot.max;
            List<String> scope = snapshot.scope.subList(1, snapshot.scope.size());
            this.activity = new JerseyRemoteActivity(onDone, onCancel, snapshot.name, () -> this.max, () -> this.current, scope, root == null ? snapshot.user : root.getUser(), System.currentTimeMillis() - snapshot.duration, uuid, parentUuid);
        }
    }
}

