/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey.activity;

import io.bdeploy.jersey.activity.JerseyBroadcastingActivityReporter;
import io.bdeploy.jersey.activity.JerseyRemoteActivity;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.Objects;

@Singleton
@Path(value="/activities")
public class JerseyRemoteActivityResourceImpl {
    @Inject
    private JerseyBroadcastingActivityReporter reporter;

    @DELETE
    @Path(value="/{taskId}")
    public void cancelTask(@PathParam(value="taskId") String taskId) {
        JerseyRemoteActivity activity = this.getActivityById(taskId);
        if (activity != null && !activity.isCancelRequested()) {
            activity.requestCancel();
            if (activity.getParentUuid() != null) {
                this.cancelTask(activity.getParentUuid());
            }
        }
    }

    private JerseyRemoteActivity getActivityById(String taskId) {
        return this.reporter.getGlobalActivities().stream().filter(Objects::nonNull).filter(a -> a.getUuid().equals(taskId)).findFirst().orElse(null);
    }
}

