/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey.activity;

import com.google.common.base.Splitter;
import io.bdeploy.jersey.ActivityScope;
import io.bdeploy.jersey.JerseyScopeService;
import io.bdeploy.jersey.activity.JerseyBroadcastingActivityReporter;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.glassfish.jersey.model.Parameter;
import org.glassfish.jersey.server.ExtendedUriInfo;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.model.ResourceMethod;

@Provider
public class JerseyRemoteActivityScopeServerFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    @Inject
    private jakarta.inject.Provider<MultivaluedParameterExtractorProvider> mpep;
    @Inject
    private JerseyScopeService scopeService;
    @Inject
    private JerseyBroadcastingActivityReporter reporter;

    @Override
    public void filter(ContainerRequestContext requestContext) throws IOException {
        this.reporter.resetCurrentActivity();
        UriInfo plainInfo = requestContext.getUriInfo();
        if (plainInfo instanceof ExtendedUriInfo) {
            ArrayList<String> scope = new ArrayList<String>();
            String proxyScope = requestContext.getHeaderString("X-Proxy-Activity-Scope");
            if (proxyScope != null) {
                if (proxyScope.contains(",")) {
                    scope.addAll(Splitter.on(',').splitToList(proxyScope));
                } else {
                    scope.add(proxyScope);
                }
            }
            ExtendedUriInfo info = (ExtendedUriInfo)plainInfo;
            ArrayList<ResourceMethod> methods = new ArrayList<ResourceMethod>(info.getMatchedResourceLocators());
            Collections.reverse(methods);
            methods.add(info.getMatchedResourceMethod());
            for (ResourceMethod m3 : methods) {
                scope.addAll(this.getMethodScope(info, m3));
            }
            String user = "<unknown>";
            SecurityContext securityContext = requestContext.getSecurityContext();
            if (securityContext != null && securityContext.getUserPrincipal() != null) {
                user = securityContext.getUserPrincipal().getName();
            }
            this.scopeService.setScope(scope, user);
        }
    }

    @Override
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        this.scopeService.clear();
    }

    private List<String> getMethodScope(ExtendedUriInfo info, ResourceMethod m3) {
        ArrayList<String> scopesInOrder = new ArrayList<String>();
        for (Parameter param : m3.getInvocable().getParameters()) {
            MultivaluedMap<String, String> parameters;
            if (param.getAnnotation(ActivityScope.class) == null) continue;
            if (param.getSource() != Parameter.Source.PATH && param.getSource() != Parameter.Source.QUERY) {
                throw new IllegalStateException("ActivityScope can only be annotated on QueryParam or PathParam: " + m3);
            }
            MultivaluedMap<String, String> multivaluedMap = parameters = param.getSource() == Parameter.Source.QUERY ? info.getQueryParameters() : info.getPathParameters();
            Object value = this.mpep.get().get(param).extract(parameters);
            if (value == null) continue;
            scopesInOrder.add(value.toString());
        }
        return scopesInOrder;
    }

    public static List<String> getRequestActivityScope(JerseyScopeService jss) {
        if (jss == null) {
            return Collections.emptyList();
        }
        List<String> result = jss.getScope();
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }
}

