/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey.cli;

import io.bdeploy.common.cfg.Configuration;
import io.bdeploy.common.cfg.RemoteValidator;
import io.bdeploy.common.cli.ToolBase;
import io.bdeploy.common.cli.ToolCategory;
import io.bdeploy.common.cli.data.DataTable;
import io.bdeploy.common.cli.data.RenderableResult;
import io.bdeploy.jersey.cli.LocalLoginData;
import io.bdeploy.jersey.cli.LocalLoginManager;
import io.bdeploy.jersey.cli.LocalLoginServer;
import java.util.Map;

@Configuration.Help(value="Manage local login sessions")
@ToolCategory(value="Local session and scripting commands")
@ToolBase.CliTool.CliName(value="login")
public class LocalLoginTool
extends ToolBase.ConfiguredCliTool<LoginConfig> {
    public LocalLoginTool() {
        super(LoginConfig.class);
    }

    @Override
    protected RenderableResult run(LoginConfig config) {
        LocalLoginManager llm = new LocalLoginManager();
        if (config.add() != null) {
            this.addUser(config, llm);
        } else if (config.remove() != null) {
            llm.remove(config.remove());
        } else if (config.use() != null) {
            llm.setCurrent(config.use());
        } else {
            if (config.list()) {
                LocalLoginData data = llm.read();
                DataTable table = this.createDataTable();
                table.column("Name", 15).column("URI", 40).column("User", 20).column("Active", 6);
                for (Map.Entry<String, LocalLoginServer> entry : data.servers.entrySet()) {
                    table.row().cell(entry.getKey()).cell(entry.getValue().url).cell(entry.getValue().user).cell(data.current != null && data.current.equals(entry.getKey()) ? "*" : "").build();
                }
                return table;
            }
            return this.createNoOp();
        }
        return this.createSuccess();
    }

    private void addUser(LoginConfig config, LocalLoginManager llm) {
        char[] pass;
        String user;
        this.helpAndFailIfMissing(config.remote(), "Missing --remote");
        if (config.user() == null || config.password() == null) {
            this.out().println("Please specify user and password for " + config.remote());
        }
        if (config.user() != null) {
            user = config.user();
        } else {
            this.out().print("User: ");
            user = System.console().readLine();
        }
        if (config.password() != null) {
            pass = config.password().toCharArray();
        } else {
            this.out().print("Password: ");
            pass = System.console().readPassword();
        }
        llm.login(config.add(), config.remote(), user, new String(pass));
    }

    @Configuration.Help(value="Configuration for remote access")
    public static @interface LoginConfig {
        @Configuration.Help(value="URI of remote Server")
        @Configuration.EnvironmentFallback(value="BDEPLOY_REMOTE")
        @Configuration.Validator(value={RemoteValidator.class})
        public String remote();

        @Configuration.Help(value="Perform a login to the given remote and store the session locally using the given name")
        public String add();

        @Configuration.Help(value="User to login, read from console if not given")
        public String user();

        @Configuration.Help(value="Password to use when logging in, read from console if not given")
        public String password();

        @Configuration.Help(value="Remove the given stored login session")
        public String remove();

        @Configuration.Help(value="List all stored login sessions", arg=false)
        public boolean list() default false;

        @Configuration.Help(value="The name of the stored login session to switch to")
        public String use();
    }
}

