/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey.errorpages;

import io.bdeploy.common.util.StreamHelper;
import io.bdeploy.common.util.TemplateHelper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.TreeMap;

public class JerseyCustomErrorPages {
    private static final String ERROR_TEMPLATE = JerseyCustomErrorPages.readTemplate();
    private static final String LOGO_TEMPLATE = JerseyCustomErrorPages.readLogo();
    private static final Map<Integer, String> codeImages = new TreeMap<Integer, String>();

    private JerseyCustomErrorPages() {
    }

    private static String readTemplate() {
        String string;
        block8: {
            InputStream is = JerseyCustomErrorPages.class.getResourceAsStream("error-template.html");
            try {
                string = new String(StreamHelper.read(is), StandardCharsets.UTF_8);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return "ERROR (no template): {{ERROR}}";
                }
            }
            is.close();
        }
        return string;
    }

    private static String readErrorImage(int code) {
        String string;
        block8: {
            InputStream is = JerseyCustomErrorPages.class.getResourceAsStream("errors/" + code + ".svg");
            try {
                string = new String(StreamHelper.read(is), StandardCharsets.UTF_8);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            is.close();
        }
        return string;
    }

    private static synchronized String readErrorImageCached(int code) {
        return codeImages.computeIfAbsent(code, JerseyCustomErrorPages::readErrorImage);
    }

    private static String readLogo() {
        String string;
        block8: {
            InputStream is = JerseyCustomErrorPages.class.getResourceAsStream("logo.svg");
            try {
                string = new String(StreamHelper.read(is), StandardCharsets.UTF_8);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return "<svg></svg>";
                }
            }
            is.close();
        }
        return string;
    }

    public static String getErrorHtml(int code, String message) {
        return TemplateHelper.process(ERROR_TEMPLATE, v -> {
            switch (v) {
                case "ERROR": {
                    return message;
                }
                case "LOGO": {
                    String img = JerseyCustomErrorPages.readErrorImageCached(code);
                    if (img != null) {
                        return img;
                    }
                    return TemplateHelper.process(LOGO_TEMPLATE, vv -> {
                        if (vv.equals("CODE")) {
                            return String.valueOf(code);
                        }
                        return null;
                    });
                }
            }
            return null;
        });
    }
}

