/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey.fs;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import org.jvnet.hk2.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class FileSystemSpaceService {
    private static final Logger log = LoggerFactory.getLogger(FileSystemSpaceService.class);
    @Inject
    @Named(value="FileSystemMinSpace")
    private Provider<Long> minFreeBytes;

    public long getFreeSpace(Path path) {
        try {
            FileStore store = Files.getFileStore(path);
            if (store == null) {
                return -1L;
            }
            return store.getUsableSpace();
        }
        catch (Exception e) {
            log.error("Cannot check remaining free disc space for {}", (Object)path, (Object)e);
            return -1L;
        }
    }

    public boolean hasFreeSpace(Path path) {
        long freeSpace = this.getFreeSpace(path);
        if (this.minFreeBytes.get() == null) {
            return true;
        }
        if (freeSpace < 0L) {
            return true;
        }
        return freeSpace > this.minFreeBytes.get();
    }
}

