/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey.ws.change;

import io.bdeploy.common.security.ApiAccessToken;
import io.bdeploy.common.util.JacksonHelper;
import io.bdeploy.jersey.JerseyAuthenticationProvider;
import io.bdeploy.jersey.ws.change.ObjectChangeWebSocket;
import io.bdeploy.jersey.ws.change.msg.ObjectChangeInitDto;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.security.KeyStore;
import java.util.concurrent.ScheduledFuture;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ObjectChangeInitListener
extends WebSocketAdapter {
    private static final Logger log = LoggerFactory.getLogger(ObjectChangeInitListener.class);
    private final ObjectChangeWebSocket manager;
    private final KeyStore authStore;
    private final WebSocket socket;
    private final ScheduledFuture<?> kicker;

    ObjectChangeInitListener(ObjectChangeWebSocket manager, KeyStore authStore, WebSocket socket, ScheduledFuture<?> kicker) {
        this.manager = manager;
        this.authStore = authStore;
        this.socket = socket;
        this.kicker = kicker;
    }

    @Override
    public void onMessage(WebSocket s2, String text) {
        ApiAccessToken token;
        block7: {
            ObjectChangeInitDto init;
            try {
                init = JacksonHelper.getDefaultJsonObjectMapper().readValue(text, ObjectChangeInitDto.class);
            }
            catch (IOException e) {
                log.error("Cannot read init DTO", e);
                s2.close(Response.Status.UNAUTHORIZED.getStatusCode(), "Invalid Init Message");
                return;
            }
            token = null;
            try {
                token = JerseyAuthenticationProvider.validateToken(init.token, this.authStore);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block7;
                log.debug("Cannot parse authentication token: {}", (Object)e.toString());
            }
        }
        this.kicker.cancel(false);
        if (token == null) {
            if (log.isDebugEnabled()) {
                log.debug("Invalid authentication from client, closing");
            }
            s2.close(Response.Status.UNAUTHORIZED.getStatusCode(), "Invalid Authentication Token");
        } else {
            this.socket.remove(this);
            this.manager.add(this.socket);
        }
    }
}

