/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey.ws.change;

import io.bdeploy.jersey.ws.change.msg.ObjectScope;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class ObjectChangeRegistration {
    private final Map<String, List<ObjectScope>> registrations = new ConcurrentHashMap<String, List<ObjectScope>>();
    private final List<Consumer<ObjectChangeRegistration>> listeners = new ArrayList<Consumer<ObjectChangeRegistration>>();

    public void add(String type, ObjectScope scope) {
        this.registrations.computeIfAbsent(type, t -> new ArrayList()).add(scope);
        this.notifyListeners();
    }

    public void remove(String type, ObjectScope scope) {
        List<ObjectScope> reg = this.registrations.get(type);
        if (reg != null) {
            reg.remove(scope);
        }
        this.notifyListeners();
    }

    public boolean matches(String type, ObjectScope scope) {
        List<ObjectScope> reg = this.registrations.get(type);
        if (reg == null) {
            return false;
        }
        for (ObjectScope s2 : reg) {
            if (!s2.matches(scope)) continue;
            return true;
        }
        return false;
    }

    public ObjectScope getBestScoring(String type, ObjectScope scope) {
        if (!this.matches(type, scope)) {
            return null;
        }
        ObjectScope result = null;
        int score = 0;
        for (ObjectScope s2 : this.registrations.get(type)) {
            int ss = s2.score(scope);
            if (ss <= score && (result == null || ss != score || s2.length() >= result.length())) continue;
            score = ss;
            result = s2;
        }
        return result;
    }

    public void addListener(Consumer<ObjectChangeRegistration> listener) {
        this.listeners.add(listener);
    }

    private void notifyListeners() {
        for (Consumer<ObjectChangeRegistration> x : this.listeners) {
            x.accept(this);
        }
    }
}

