/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey.ws.change;

import io.bdeploy.common.util.JacksonHelper;
import io.bdeploy.jersey.ws.change.ObjectChangeRegistration;
import io.bdeploy.jersey.ws.change.msg.ObjectChangeRegistrationDto;
import java.io.IOException;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectChangeRegistrationListener
extends WebSocketAdapter {
    private static final Logger log = LoggerFactory.getLogger(ObjectChangeRegistrationListener.class);
    private final ObjectChangeRegistration registration;

    public ObjectChangeRegistrationListener(ObjectChangeRegistration registration) {
        this.registration = registration;
    }

    @Override
    public void onMessage(WebSocket socket, String text) {
        try {
            ObjectChangeRegistrationDto change = JacksonHelper.getDefaultJsonObjectMapper().readValue(text, ObjectChangeRegistrationDto.class);
            if (change.action == ObjectChangeRegistrationDto.RegistrationAction.ADD) {
                this.registration.add(change.type, change.scope);
            } else if (change.action == ObjectChangeRegistrationDto.RegistrationAction.REMOVE) {
                this.registration.remove(change.type, change.scope);
            } else {
                log.error("Unknown action to perform on registration: {}", (Object)change.action);
            }
        }
        catch (IOException e) {
            log.error("Cannot read registration from WebSocket", e);
        }
    }
}

