/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey.ws.change;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.bdeploy.common.util.JacksonHelper;
import io.bdeploy.jersey.ws.change.ObjectChangeBroadcaster;
import io.bdeploy.jersey.ws.change.ObjectChangeInitListener;
import io.bdeploy.jersey.ws.change.ObjectChangeRegistration;
import io.bdeploy.jersey.ws.change.ObjectChangeRegistrationListener;
import io.bdeploy.jersey.ws.change.msg.ObjectChangeDto;
import io.bdeploy.jersey.ws.change.msg.ObjectScope;
import jakarta.ws.rs.core.Response;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.glassfish.grizzly.websockets.Broadcaster;
import org.glassfish.grizzly.websockets.OptimizedBroadcaster;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketApplication;

public class ObjectChangeWebSocket
extends WebSocketApplication
implements ObjectChangeBroadcaster {
    public static final String OCWS_PATH = "/object-changes";
    private final Broadcaster broadcaster;
    private final KeyStore authStore;
    private final ScheduledExecutorService autoCloser = Executors.newSingleThreadScheduledExecutor();
    private final ConcurrentMap<WebSocket, ObjectChangeRegistration> webSockets = new ConcurrentHashMap<WebSocket, ObjectChangeRegistration>();
    private final List<Consumer<ObjectChangeRegistration>> listeners = new ArrayList<Consumer<ObjectChangeRegistration>>();

    public ObjectChangeWebSocket(KeyStore authStore) {
        this.authStore = authStore;
        this.broadcaster = new OptimizedBroadcaster();
    }

    @Override
    public void send(ObjectChangeDto change) {
        try {
            Set<WebSocket> targets = this.getWebSockets(change);
            this.broadcaster.broadcast(targets, JacksonHelper.getDefaultJsonObjectMapper().writeValueAsString(change));
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Cannot write JSON to WebSocket", e);
        }
    }

    @Override
    public void sendBestMatching(List<ObjectChangeDto> changes) {
        try {
            HashMap<ObjectChangeDto, List> targets = new HashMap<ObjectChangeDto, List>();
            for (Map.Entry entry : this.webSockets.entrySet()) {
                ObjectChangeDto best = null;
                int bestScore = 0;
                for (ObjectChangeDto change : changes) {
                    int score;
                    ObjectScope match = ((ObjectChangeRegistration)entry.getValue()).getBestScoring(change.type, change.scope);
                    if (match == null || (score = match.score(change.scope)) <= bestScore && (score != bestScore || best != null && best.scope.length() <= match.length())) continue;
                    bestScore = score;
                    best = change;
                }
                if (best == null) continue;
                targets.computeIfAbsent(best, k -> new ArrayList()).add((WebSocket)entry.getKey());
            }
            for (Map.Entry target : targets.entrySet()) {
                this.broadcaster.broadcast((Iterable<? extends WebSocket>)((Iterable)target.getValue()), JacksonHelper.getDefaultJsonObjectMapper().writeValueAsString(target.getKey()));
            }
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Cannot write JSON to WebSocket", e);
        }
    }

    @Override
    public void onConnect(WebSocket socket) {
        ScheduledFuture<?> schedule = this.autoCloser.schedule(() -> socket.close(Response.Status.UNAUTHORIZED.getStatusCode(), "No Token received"), 5L, TimeUnit.SECONDS);
        socket.add(new ObjectChangeInitListener(this, this.authStore, socket, schedule));
    }

    @Override
    protected boolean add(WebSocket socket) {
        ObjectChangeRegistration reg = new ObjectChangeRegistration();
        this.listeners.forEach(reg::addListener);
        socket.add(new ObjectChangeRegistrationListener(reg));
        return this.webSockets.put(socket, reg) == null;
    }

    @Override
    public boolean remove(WebSocket socket) {
        return this.webSockets.remove(socket) != null;
    }

    @Override
    protected Set<WebSocket> getWebSockets() {
        throw new UnsupportedOperationException();
    }

    private Set<WebSocket> getWebSockets(ObjectChangeDto change) {
        return this.webSockets.entrySet().stream().filter(e -> ((ObjectChangeRegistration)e.getValue()).matches(change.type, change.scope)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public void addListener(Consumer<ObjectChangeRegistration> listener) {
        this.listeners.add(listener);
        for (ObjectChangeRegistration existing : this.webSockets.values()) {
            existing.addListener(listener);
        }
    }
}

