/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey.ws.change.client;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ws.WebSocket;
import io.bdeploy.common.NoThrowAutoCloseable;
import io.bdeploy.common.util.JacksonHelper;
import io.bdeploy.jersey.ws.change.msg.ObjectChangeRegistrationDto;
import io.bdeploy.jersey.ws.change.msg.ObjectScope;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectChangeClientWebSocket
implements NoThrowAutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ObjectChangeClientWebSocket.class);
    private final AsyncHttpClient client;
    private final WebSocket connection;

    public ObjectChangeClientWebSocket(AsyncHttpClient client, WebSocket webSocket) {
        this.client = client;
        this.connection = webSocket;
    }

    public void subscribe(String type, ObjectScope scope) {
        this.writeChange(ObjectChangeRegistrationDto.RegistrationAction.ADD, type, scope);
    }

    public void unsubscribe(String type, ObjectScope scope) {
        this.writeChange(ObjectChangeRegistrationDto.RegistrationAction.REMOVE, type, scope);
    }

    @Override
    public void close() {
        this.connection.close();
        this.client.close();
    }

    private void writeChange(ObjectChangeRegistrationDto.RegistrationAction action, String type, ObjectScope scope) {
        try {
            ObjectChangeRegistrationDto reg = new ObjectChangeRegistrationDto();
            reg.action = action;
            reg.type = type;
            reg.scope = scope;
            this.connection.sendMessage(JacksonHelper.getDefaultJsonObjectMapper().writeValueAsString(reg));
        }
        catch (IOException e) {
            log.error("Cannot subscribe to object changes", e);
        }
    }
}

