/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey.ws.change.msg;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ObjectScope
implements Comparable<ObjectScope> {
    public static final ObjectScope EMPTY = new ObjectScope(Collections.emptyList());
    private final List<String> scope;

    @JsonCreator
    public ObjectScope(@JsonProperty(value="scope") List<String> scope) {
        this.scope = scope == null ? Collections.emptyList() : scope;
    }

    public ObjectScope(String ... scope) {
        this.scope = Arrays.asList(scope);
    }

    public boolean matches(ObjectScope other) {
        if (this.scope.size() > other.scope.size()) {
            return false;
        }
        for (int i = 0; i < this.scope.size(); ++i) {
            if (Objects.equals(this.scope.get(i), other.scope.get(i))) continue;
            return false;
        }
        return true;
    }

    public int score(ObjectScope other) {
        if (!this.matches(other)) {
            return 0;
        }
        if (this.scope.isEmpty() && other.scope.isEmpty()) {
            return 100;
        }
        return Math.min(100, Math.round(100.0f * (float)other.scope.size() / (float)this.scope.size()));
    }

    public int length() {
        return this.scope.size();
    }

    public String toString() {
        return this.scope.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectScope other = (ObjectScope)obj;
        return !(this.scope == null ? other.scope != null : !this.scope.equals(other.scope));
    }

    @Override
    public int compareTo(ObjectScope o) {
        if (this.scope.size() > o.scope.size()) {
            return 1;
        }
        if (this.scope.size() > o.scope.size()) {
            return -1;
        }
        for (int i = 0; i < this.scope.size(); ++i) {
            int r = this.scope.get(i).compareTo(o.scope.get(i));
            if (r == 0) continue;
            return r;
        }
        return 0;
    }
}

