/*
 * Decompiled with CFR 0.152.
 */
package mcouch.core.couch;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mcouch.core.couch.DocumentIterator;
import mcouch.core.http.response.SuccessfulDocumentCreateResponse;
import mcouch.core.rhino.DocumentFunctions;
import mcouch.core.rhino.JavaScriptInterpreter;

public class AllDocuments {
    private Map<String, String> all = new HashMap<String, String>();
    private final DocumentFunctions documentFunctions;

    public AllDocuments(JavaScriptInterpreter javaScriptInterpreter) {
        this.documentFunctions = new DocumentFunctions(javaScriptInterpreter);
    }

    public Object remove(String key) {
        return this.all.remove(key);
    }

    public SuccessfulDocumentCreateResponse add(String document) {
        String id = UUID.randomUUID().toString();
        String rev = UUID.randomUUID().toString();
        String updatedDoc = this.documentFunctions.updateNewDocument(document, id, rev);
        SuccessfulDocumentCreateResponse response = new SuccessfulDocumentCreateResponse(id, rev);
        this.all.put(id, updatedDoc);
        return response;
    }

    public String get(String key) {
        return this.all.get(key);
    }

    public void doForAllDocuments(DocumentIterator documentIterator) {
        Set<String> docIds = this.all.keySet();
        for (String docId : docIds) {
            String document = this.all.get(docId);
            documentIterator.iterate(docId, document);
        }
    }

    public Map<String, String> getAll(List<String> documentIds) {
        HashMap<String, String> documents = new HashMap<String, String>(documentIds.size());
        for (String documentId : documentIds) {
            documents.put(documentId, this.get(documentId));
        }
        return documents;
    }

    public int size() {
        return this.all.size();
    }

    public SuccessfulDocumentCreateResponse update(String document) {
        String documentId = this.documentId(document);
        return this.update(documentId, document);
    }

    private SuccessfulDocumentCreateResponse update(String documentId, String document) {
        String newRevision = UUID.randomUUID().toString();
        String updatedDocument = this.documentFunctions.updateExistingDocument(document, newRevision);
        this.all.put(documentId, updatedDocument);
        return new SuccessfulDocumentCreateResponse(documentId, newRevision);
    }

    private String documentId(String document) {
        return this.documentFunctions.getDocumentId(document);
    }

    public void addOrUpdate(String document) {
        String documentId = this.documentId(document);
        if (documentId == null || !this.all.containsKey(documentId)) {
            this.add(document);
        } else {
            this.update(documentId, document);
        }
    }
}

