/*
 * Decompiled with CFR 0.152.
 */
package mcouch.core.couch.database;

import java.util.HashMap;
import java.util.Map;
import mcouch.core.couch.AllDocuments;
import mcouch.core.couch.indexing.IndexEntry;
import mcouch.core.couch.indexing.IndexKey;
import mcouch.core.couch.indexing.IndexValue;
import mcouch.core.couch.indexing.Indexes;
import mcouch.core.couch.indexing.View;
import mcouch.core.couch.indexing.query.IndexQuery;
import mcouch.core.couch.reducers.Reducer;
import mcouch.core.couch.view.ViewDefinition;
import mcouch.core.couch.view.ViewGroup;
import mcouch.core.couch.view.ViewGroupDefinition;
import mcouch.core.http.request.Page;
import mcouch.core.http.response.SuccessfulDocumentCreateResponse;
import mcouch.core.http.response.ViewCustomStructureResponse;
import mcouch.core.http.response.ViewDocumentResponse;
import mcouch.core.http.response.ViewDocumentsResponse;
import mcouch.core.jackson.JSONSerializer;
import mcouch.core.rhino.DocumentFunctions;
import mcouch.core.rhino.JavaScriptInterpreter;
import mcouch.core.rhino.MapFunctionInterpreter;

public class Database {
    private AllDocuments allDocuments;
    private Map<String, ViewGroup> viewGroups = new HashMap<String, ViewGroup>();
    private Indexes indexes;
    public static String ReducedResult = "{\"rows\":[{\"key\":null,\"value\":%s}]}";
    private String name;
    private JavaScriptInterpreter javaScriptInterpreter;
    private final DocumentFunctions documentFunctions;

    public Database(String name, MapFunctionInterpreter mapFunctionInterpreter, JavaScriptInterpreter javaScriptInterpreter) {
        this.name = name;
        this.javaScriptInterpreter = javaScriptInterpreter;
        this.indexes = new Indexes(mapFunctionInterpreter);
        this.allDocuments = new AllDocuments(javaScriptInterpreter);
        this.documentFunctions = new DocumentFunctions(javaScriptInterpreter);
    }

    public ViewGroup createViewGroup(String viewGroupName, String document) {
        ViewGroup viewGroup = new ViewGroup(viewGroupName, document, this.documentFunctions);
        this.viewGroups.put(viewGroupName, viewGroup);
        return viewGroup;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Database database = (Database)o;
        return this.name.equals(database.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return String.format("Database{documentCount=%d, viewGroupsCount=%d, name='%s'}", this.allDocuments.size(), this.viewGroups.size(), this.name);
    }

    public boolean containsViewGroup(String viewGroupName) {
        return this.viewGroups.containsKey(viewGroupName);
    }

    public ViewGroup viewGroup(String name) {
        return this.viewGroups.get(name);
    }

    public String executeView(String viewGroupName, String viewName, IndexQuery indexQuery, boolean doReduce, Page page) {
        ViewGroup viewGroup = this.viewGroup(viewGroupName);
        ViewGroupDefinition viewGroupDefinition = viewGroup.definition();
        ViewDefinition viewDefinition = viewGroupDefinition.getView(viewName);
        View view = this.indexes.buildIndex(viewName, viewDefinition.map, this.allDocuments);
        Map<IndexKey, IndexEntry> map = indexQuery.execute(view);
        Reducer reducer = viewDefinition.reducer();
        if (doReduce && reducer != null) {
            return String.format(ReducedResult, reducer.reduce(map));
        }
        ViewDocumentsResponse viewDocumentsResponse = new ViewDocumentsResponse(this.allDocuments.size(), 0);
        int i = 0;
        for (IndexKey indexKey : map.keySet()) {
            IndexEntry indexEntry = map.get(indexKey);
            for (IndexValue indexValue : indexEntry.indexedValues()) {
                if (page.fallsOutOf(i)) {
                    ++i;
                    continue;
                }
                if (indexValue.isDocId()) {
                    ViewDocumentResponse viewDocumentResponse = new ViewDocumentResponse(indexValue.getDocId(), indexKey.value(), indexValue.getDocId(), this.allDocuments.get(indexValue.getDocId()));
                    viewDocumentsResponse.add(viewDocumentResponse);
                } else {
                    ViewCustomStructureResponse viewCustomStructureResponse = new ViewCustomStructureResponse(indexValue.getDocId(), indexKey.value(), this.javaScriptInterpreter.stringiFy(indexValue.getObject()));
                    viewDocumentsResponse.add(viewCustomStructureResponse);
                }
                ++i;
            }
        }
        return JSONSerializer.toJson(viewDocumentsResponse);
    }

    public SuccessfulDocumentCreateResponse addDocument(String document) {
        return this.allDocuments.add(document);
    }

    public String get(String documentId) {
        return this.allDocuments.get(documentId);
    }

    public String name() {
        return this.name;
    }

    public SuccessfulDocumentCreateResponse updateDocument(String document) {
        return this.allDocuments.update(document);
    }

    public void delete(String id) {
        this.allDocuments.remove(id);
    }

    public void addOrUpdate(String document) {
        this.allDocuments.addOrUpdate(document);
    }
}

