/*
 * Decompiled with CFR 0.152.
 */
package mcouch.core.http.request;

import mcouch.core.couch.database.Database;
import mcouch.core.couch.database.Databases;
import mcouch.core.couch.indexing.query.IndexQuery;
import mcouch.core.couch.indexing.query.IndexQueryFactory;
import mcouch.core.couch.view.ViewGroupDefinition;
import mcouch.core.http.NotImplementedException;
import mcouch.core.http.StandardHttpResponse;
import mcouch.core.http.request.CouchRequest;
import mcouch.core.http.request.CouchURI;
import mcouch.core.http.request.Page;
import mcouch.core.rhino.JavaScriptInterpreter;
import org.apache.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchGetRequest
implements CouchRequest {
    private CouchURI uri;
    private JavaScriptInterpreter javaScriptInterpreter;
    private static Logger logger = LoggerFactory.getLogger(CouchGetRequest.class);

    public CouchGetRequest(CouchURI uri, JavaScriptInterpreter javaScriptInterpreter) {
        this.uri = uri;
        this.javaScriptInterpreter = javaScriptInterpreter;
    }

    @Override
    public HttpResponse execute(Databases databases) {
        if (!databases.contains(this.uri.databaseName())) {
            throw new NotImplementedException();
        }
        Database database = databases.getDatabase(this.uri.databaseName());
        if (this.uri.isGetViewDocRequest()) {
            ViewGroupDefinition viewGroupDefinition = database.viewGroup(this.uri.viewGroup()).definition();
            return StandardHttpResponse.okWith(viewGroupDefinition.document());
        }
        if (this.uri.isDocRequest()) {
            String doc = database.get(this.uri.documentId());
            if (doc != null) {
                return StandardHttpResponse.okWith(doc);
            }
            return StandardHttpResponse.DOC_NOT_FOUND;
        }
        if (this.uri.isAllDocsRequest() || this.uri.isExecuteViewRequest()) {
            IndexQuery indexQuery = IndexQueryFactory.create(this.uri, this.javaScriptInterpreter);
            Page page = this.uri.page();
            String response = database.executeView(this.uri.viewGroup(), this.uri.viewName(), indexQuery, this.uri.isReduce(), page);
            if (logger.isDebugEnabled()) {
                logger.debug(response);
            }
            return StandardHttpResponse.okWith(response);
        }
        return null;
    }
}

