/*
 * Decompiled with CFR 0.152.
 */
package mcouch.core.http.request;

import mcouch.core.couch.database.Database;
import mcouch.core.couch.database.Databases;
import mcouch.core.http.StandardHttpResponse;
import mcouch.core.http.request.CouchRequest;
import mcouch.core.http.request.CouchURI;
import org.apache.http.HttpResponse;

public class CouchHeadRequest
implements CouchRequest {
    private CouchURI uri;

    public CouchHeadRequest(CouchURI uri) {
        this.uri = uri;
    }

    @Override
    public HttpResponse execute(Databases databases) {
        if (this.uri.viewGroup() == null) {
            return this.responseBasedOnPresence(databases.contains(this.uri.databaseName()));
        }
        if (databases.contains(this.uri.databaseName()) && this.uri.viewGroup() != null) {
            Database database = databases.getDatabase(this.uri.databaseName());
            return this.responseBasedOnPresence(database.containsViewGroup(this.uri.viewGroup()));
        }
        return null;
    }

    private HttpResponse responseBasedOnPresence(boolean presence) {
        return presence ? StandardHttpResponse.OK : StandardHttpResponse.NOT_FOUND;
    }
}

