/*
 * Decompiled with CFR 0.152.
 */
package mcouch.core.http.request;

import mcouch.core.http.NotImplementedException;
import mcouch.core.http.request.CouchDeleteRequest;
import mcouch.core.http.request.CouchGetRequest;
import mcouch.core.http.request.CouchHeadRequest;
import mcouch.core.http.request.CouchPostRequest;
import mcouch.core.http.request.CouchPutRequest;
import mcouch.core.http.request.CouchRequest;
import mcouch.core.http.request.CouchURI;
import mcouch.core.rhino.JavaScriptInterpreter;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;

public class CouchHttpRequestFactory {
    private JavaScriptInterpreter javaScriptInterpreter;

    public CouchHttpRequestFactory(JavaScriptInterpreter javaScriptInterpreter) {
        this.javaScriptInterpreter = javaScriptInterpreter;
    }

    public CouchRequest create(HttpRequestBase request) {
        switch (request.getMethod()) {
            case "HEAD": {
                return new CouchHeadRequest(new CouchURI(request.getURI()));
            }
            case "GET": {
                return new CouchGetRequest(new CouchURI(request.getURI()), this.javaScriptInterpreter);
            }
            case "PUT": {
                return new CouchPutRequest((HttpPut)request);
            }
            case "POST": {
                return new CouchPostRequest((HttpPost)request);
            }
            case "DELETE": {
                return new CouchDeleteRequest(new CouchURI(request.getURI()));
            }
        }
        throw new NotImplementedException(String.format("%s as Couch HTTP Request", request.getMethod()));
    }
}

