/*
 * Decompiled with CFR 0.152.
 */
package mcouch.core.http.request;

import java.net.URI;
import java.util.List;
import java.util.StringTokenizer;
import mcouch.core.http.request.NullPage;
import mcouch.core.http.request.Page;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

public class CouchURI {
    private String databaseName;
    private String viewGroup;
    private String viewName;
    private boolean bulkDocs;
    private String documentId;
    private boolean includeDocs;
    private String key;
    private String startKey;
    private String endKey;
    private boolean reduce = true;
    private boolean allDocs;
    private String rev;
    private int limit = -1;
    private int skip;
    private static final int limitNotSpecified = -1;

    public CouchURI(URI uri) {
        String uriPath = uri.getPath();
        StringTokenizer pathTokenizer = new StringTokenizer(uriPath, "/");
        if (pathTokenizer.countTokens() >= 1) {
            this.databaseName = pathTokenizer.nextToken();
        }
        if (pathTokenizer.countTokens() == 1) {
            String nextToken = pathTokenizer.nextToken();
            this.bulkDocs = nextToken.equals("_bulk_docs");
            this.allDocs = nextToken.equals("_all_docs");
            this.documentId = this.bulkDocs || this.allDocs ? null : nextToken;
            return;
        }
        if (pathTokenizer.countTokens() >= 2 && pathTokenizer.nextToken().equals("_design")) {
            this.viewGroup = pathTokenizer.nextToken();
        }
        if (pathTokenizer.countTokens() >= 2 && pathTokenizer.nextToken().equals("_view")) {
            this.viewName = pathTokenizer.nextToken();
        }
        List queryParams = URLEncodedUtils.parse((URI)uri, (String)"UTF-8");
        for (NameValuePair nameValuePair : queryParams) {
            String value = nameValuePair.getValue();
            switch (nameValuePair.getName()) {
                case "key": {
                    this.key = value;
                    break;
                }
                case "include_docs": {
                    this.includeDocs = Boolean.parseBoolean(value);
                    break;
                }
                case "startkey": {
                    this.startKey = value;
                    break;
                }
                case "endkey": {
                    this.endKey = value;
                    break;
                }
                case "reduce": {
                    this.reduce = Boolean.parseBoolean(value);
                    break;
                }
                case "rev": {
                    this.rev = value;
                    break;
                }
                case "limit": {
                    this.limit = Integer.parseInt(value);
                    break;
                }
                case "skip": {
                    this.skip = Integer.parseInt(value);
                }
            }
        }
    }

    public String databaseName() {
        return this.databaseName;
    }

    public String viewGroup() {
        return this.viewGroup;
    }

    public String viewName() {
        return this.viewName;
    }

    public boolean isGetViewDocRequest() {
        return this.databaseName != null && this.viewGroup != null && this.viewName == null;
    }

    public boolean isExecuteViewRequest() {
        return this.databaseName != null && this.viewGroup != null && this.viewName != null;
    }

    public boolean isBulkDocsRequest() {
        return this.databaseName != null && this.bulkDocs;
    }

    public boolean isBulkDocs() {
        return this.bulkDocs;
    }

    public boolean isDocRequest() {
        return this.documentId != null;
    }

    public String documentId() {
        return this.documentId;
    }

    public String getKey() {
        return this.key;
    }

    public String getStartKey() {
        return this.startKey;
    }

    public String getEndKey() {
        return this.endKey;
    }

    public boolean isReduce() {
        return this.reduce;
    }

    public boolean isAllDocsRequest() {
        return this.allDocs;
    }

    public String getRev() {
        return this.rev;
    }

    private boolean isPaged() {
        return this.limit != -1;
    }

    public Page page() {
        if (this.isPaged()) {
            return new Page(this.skip, this.limit);
        }
        return NullPage.Instance;
    }
}

