/*
 * Decompiled with CFR 0.152.
 */
package mcouch.core.couch.database;

import java.util.HashMap;
import java.util.Map;
import mcouch.core.couch.database.Database;
import mcouch.core.rhino.JavaScriptInterpreter;
import mcouch.core.rhino.MapFunctionInterpreter;

public class Databases {
    private Map<String, Database> items = new HashMap<String, Database>();
    private final MapFunctionInterpreter mapFunctionInterpreter;
    private JavaScriptInterpreter javaScriptInterpreter;

    public Databases(JavaScriptInterpreter javaScriptInterpreter, MapFunctionInterpreter mapFunctionInterpreter, Database ... databases) {
        this.javaScriptInterpreter = javaScriptInterpreter;
        this.mapFunctionInterpreter = mapFunctionInterpreter;
        for (Database database : databases) {
            this.items.put(database.name(), database);
        }
    }

    public boolean contains(String databaseName) {
        return this.items.containsKey(databaseName.toLowerCase());
    }

    public Database getDatabase(String databaseName) {
        return this.items.get(databaseName.toLowerCase());
    }

    public void create(String databaseName) {
        this.items.put(databaseName.toLowerCase(), new Database(databaseName, this.mapFunctionInterpreter, this.javaScriptInterpreter));
    }
}

