/*
 * Decompiled with CFR 0.152.
 */
package mcouch.core.couch.indexing;

import java.util.NavigableMap;
import java.util.TreeMap;
import mcouch.core.couch.AllDocuments;
import mcouch.core.couch.DocumentIterator;
import mcouch.core.couch.indexing.IndexEntry;
import mcouch.core.couch.indexing.IndexKey;
import mcouch.core.couch.indexing.IndexKeyComparator;
import mcouch.core.couch.indexing.IndexKeyFactory;
import mcouch.core.rhino.MapFunctionInterpreter;

public class View
implements DocumentIterator {
    private String name;
    private MapFunctionInterpreter mapFunctionInterpreter;
    private String mapFunction;
    private TreeMap<IndexKey, IndexEntry> treeMap = new TreeMap(new IndexKeyComparator());

    public View(String name, MapFunctionInterpreter mapFunctionInterpreter, String mapFunction) {
        this.name = name;
        this.mapFunctionInterpreter = mapFunctionInterpreter;
        this.mapFunction = mapFunction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        View view = (View)o;
        return this.name.equals(view.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public void iterate(String id, String document) {
        this.mapFunctionInterpreter.interpret(this.mapFunction, id, document);
    }

    public void build(AllDocuments allDocuments) {
        this.mapFunctionInterpreter.emitOn(this);
        allDocuments.doForAllDocuments(this);
    }

    public void addOrUpdate(String indexValue, Object object, String docId) {
        IndexKey indexKey = IndexKeyFactory.create(indexValue);
        IndexEntry indexEntry = this.treeMap.get(indexKey);
        if (indexEntry == null) {
            this.treeMap.put(indexKey, new IndexEntry(object, docId));
        } else {
            indexEntry.append(object, docId);
        }
    }

    public NavigableMap<IndexKey, IndexEntry> get(IndexKey indexKey) {
        return this.itemsBetween(indexKey, indexKey);
    }

    public NavigableMap<IndexKey, IndexEntry> itemsBetween(IndexKey startKey, IndexKey endKey) {
        return this.treeMap.subMap(startKey, true, endKey, true);
    }

    public NavigableMap<IndexKey, IndexEntry> all() {
        return this.treeMap;
    }
}

