/*
 * Decompiled with CFR 0.152.
 */
package io.beanmother.core;

import io.beanmother.core.BeanMother;
import io.beanmother.core.common.FixtureMap;
import io.beanmother.core.common.FixtureMapTraversal;
import io.beanmother.core.common.FixtureValue;
import io.beanmother.core.converter.ConverterFactory;
import io.beanmother.core.loader.Location;
import io.beanmother.core.loader.store.DefaultFixturesStore;
import io.beanmother.core.loader.store.FixturesStore;
import io.beanmother.core.mapper.ConstructHelper;
import io.beanmother.core.mapper.DefaultFixtureMapper;
import io.beanmother.core.mapper.FixtureConverter;
import io.beanmother.core.mapper.FixtureMapper;
import io.beanmother.core.postprocessor.PostProcessor;
import io.beanmother.core.postprocessor.PostProcessorFactory;
import io.beanmother.core.script.DefaultScriptHandler;
import io.beanmother.core.script.ScriptFragment;
import io.beanmother.core.script.ScriptHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractBeanMother
implements BeanMother {
    private FixturesStore fixturesStore = new DefaultFixturesStore();
    private ConverterFactory converterFactory = new ConverterFactory();
    private FixtureMapper fixtureMapper = new DefaultFixtureMapper(this.converterFactory);
    private FixtureConverter fixtureConverter = ((DefaultFixtureMapper)this.fixtureMapper).getFixtureConverter();
    private ScriptHandler scriptHandler = new DefaultScriptHandler();
    private PostProcessorFactory postProcessorFactory = new PostProcessorFactory();

    public FixturesStore getFixturesStore() {
        return this.fixturesStore;
    }

    protected AbstractBeanMother() {
        this.initialize();
    }

    @Override
    public <T> T bear(String fixtureName, T target) {
        return this.bear(fixtureName, target, null);
    }

    @Override
    public <T> T bear(String fixtureName, Class<T> targetClass) {
        FixtureMap fixtureMap = this.fixturesStore.reproduce(fixtureName);
        Object inst = ConstructHelper.construct(targetClass, fixtureMap, this.fixtureConverter);
        return (T)this._bear(inst, fixtureMap, null);
    }

    @Override
    public <T> T bear(String fixtureName, T target, PostProcessor<T> postProcessor) {
        FixtureMap fixtureMap = this.fixturesStore.reproduce(fixtureName);
        return this._bear(target, fixtureMap, postProcessor);
    }

    @Override
    public <T> T bear(String fixtureName, Class<T> targetClass, PostProcessor<T> postProcessor) {
        FixtureMap fixtureMap = this.fixturesStore.reproduce(fixtureName);
        Object inst = ConstructHelper.construct(targetClass, fixtureMap, this.fixtureConverter);
        return (T)this._bear(inst, fixtureMap, postProcessor);
    }

    @Override
    public <T> List<T> bear(String fixtureName, Class<T> targetClass, int size) {
        return this.bear(fixtureName, targetClass, size, null);
    }

    @Override
    public <T> List<T> bear(String fixtureName, Class<T> targetClass, int size, PostProcessor<T> postProcessor) {
        ArrayList<T> result = new ArrayList<T>();
        for (int i = 0; i < size; ++i) {
            result.add(this.bear(fixtureName, targetClass, postProcessor));
        }
        return result;
    }

    @Override
    public BeanMother addFixtureLocation(String path) {
        this.fixturesStore.addLocation(new Location(path));
        return this;
    }

    protected <T> T _bear(T target, FixtureMap fixtureMap, PostProcessor<T> postProcessor) {
        this.handleScriptFixtureValue(fixtureMap);
        this.fixtureMapper.map(fixtureMap, target);
        List<PostProcessor<?>> postProcessors = this.postProcessorFactory.get(target.getClass());
        if (postProcessor != null) {
            postProcessors.add(postProcessor);
            Collections.sort(postProcessors);
        }
        for (PostProcessor<?> pp : postProcessors) {
            pp.process(target, fixtureMap);
        }
        return target;
    }

    protected String[] defaultFixturePaths() {
        return new String[]{"fixtures"};
    }

    protected void configureConverterFactory(ConverterFactory converterFactory) {
    }

    protected void configureScriptHandler(ScriptHandler scriptHandler) {
    }

    protected void configurePostProcessorFactory(PostProcessorFactory postProcessorFactory) {
    }

    protected void initialize() {
        for (String path : this.defaultFixturePaths()) {
            this.fixturesStore.addLocation(new Location(path));
        }
        this.configureConverterFactory(this.converterFactory);
        this.configureScriptHandler(this.scriptHandler);
        this.configurePostProcessorFactory(this.postProcessorFactory);
    }

    private void handleScriptFixtureValue(FixtureMap fixtureMap) {
        FixtureMapTraversal.traverse(fixtureMap, new FixtureMapTraversal.Processor(){

            @Override
            public void visit(FixtureValue edge) {
                if (ScriptFragment.isScript(edge)) {
                    ScriptFragment scriptFragment = ScriptFragment.of(edge);
                    edge.setValue(AbstractBeanMother.this.scriptHandler.runScript(scriptFragment));
                }
            }
        });
    }
}

