/*
 * Decompiled with CFR 0.152.
 */
package io.beanmother.core.common;

import io.beanmother.core.common.FixtureMetadata;
import io.beanmother.core.common.FixtureTemplate;
import io.beanmother.core.loader.parser.FixtureFormatException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedHashMap;

public class FixtureMap
extends LinkedHashMap<String, FixtureTemplate>
implements FixtureTemplate {
    private FixtureMetadata metadata = new FixtureMetadata(this);

    public FixtureMap reproduce() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(2048);
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(this);
            oos.flush();
            oos.close();
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
            Object obj = ois.readObject();
            FixtureMap dup = (FixtureMap)obj;
            dup.setParent(this.getParent());
            dup.setRoot(this.isRoot());
            dup.setFixtureName(this.getFixtureName());
            return dup;
        }
        catch (Exception e) {
            throw new FixtureFormatException(this.getFixtureName(), e);
        }
    }

    public FixtureMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public boolean isRoot() {
        return this.metadata.isRoot();
    }

    @Override
    public void setRoot(boolean root) {
        this.metadata.setRoot(root);
    }

    @Override
    public String getFixtureName() {
        return this.metadata.getFixtureName();
    }

    @Override
    public void setFixtureName(String fixtureName) {
        this.metadata.setFixtureName(fixtureName);
    }

    @Override
    public FixtureTemplate getParent() {
        return this.metadata.getParent();
    }

    @Override
    public void setParent(FixtureTemplate parent) {
        this.metadata.setParent(parent);
    }

    @Override
    public boolean hasParent() {
        return this.metadata.hasParent();
    }
}

