/*
 * Decompiled with CFR 0.152.
 */
package io.beanmother.core.converter;

import com.google.common.reflect.TypeToken;
import io.beanmother.core.converter.Converter;
import io.beanmother.core.converter.ConverterModule;
import io.beanmother.core.converter.KnownConverterModuleLoader;
import io.beanmother.core.converter.std.SameClassConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ConverterFactory {
    private static Converter sameClassConverter = new SameClassConverter();
    private List<Converter> converters = new ArrayList<Converter>();

    public ConverterFactory() {
        this.registerDefaultConverterModules();
    }

    public void register(ConverterModule converterModule) {
        if (converterModule == null) {
            return;
        }
        for (Converter converter : converterModule.getConverters()) {
            this.converters.add(converter);
        }
        Collections.sort(this.converters);
    }

    public void register(Converter converter) {
        this.converters.add(converter);
        Collections.sort(this.converters);
    }

    public Converter get(Object source, TypeToken<?> targetTokenType) {
        for (Converter converter : this.converters) {
            if (!converter.canHandle(source, targetTokenType)) continue;
            return converter;
        }
        if (sameClassConverter.canHandle(source, targetTokenType)) {
            return sameClassConverter;
        }
        return null;
    }

    protected void registerDefaultConverterModules() {
        List<ConverterModule> knownModules = KnownConverterModuleLoader.load();
        for (ConverterModule module : knownModules) {
            this.register(module);
        }
    }
}

