/*
 * Decompiled with CFR 0.152.
 */
package io.beanmother.core.converter.std;

import com.google.common.reflect.TypeToken;
import io.beanmother.core.converter.AbstractConverter;
import io.beanmother.core.converter.ConverterException;

public class StringToEnumConverter
extends AbstractConverter {
    @Override
    public Object convert(Object source, TypeToken<?> targetTypeToken) {
        if (!this.canHandle(source, targetTypeToken)) {
            throw new ConverterException(source, targetTypeToken.getRawType());
        }
        Class enumClass = targetTypeToken.getRawType();
        for (Object enumConstant : enumClass.getEnumConstants()) {
            String sourceStr;
            String enumStr = enumConstant.toString().replaceAll("\\_", "");
            if (!enumStr.equalsIgnoreCase(sourceStr = ((String)source).replaceAll("\\-", "").replaceAll("\\_", "").replaceAll("\\s", ""))) continue;
            return Enum.valueOf(enumClass, enumConstant.toString());
        }
        throw new ConverterException(source, targetTypeToken.getRawType(), "can not find enum constants");
    }

    @Override
    public boolean canHandle(Object source, TypeToken<?> targetTypeToken) {
        Class enumClass = targetTypeToken.getRawType();
        return source instanceof String && enumClass.isEnum();
    }
}

