/*
 * Decompiled with CFR 0.152.
 */
package io.beanmother.core.loader;

import io.beanmother.core.common.FixtureList;
import io.beanmother.core.common.FixtureMap;
import io.beanmother.core.common.FixtureTemplate;
import io.beanmother.core.common.FixtureValue;
import java.util.List;
import java.util.Map;

public class FixtureTemplateWrapper {
    public static FixtureMap wrap(Map<String, ? extends Object> source, String fixtureName, FixtureTemplate parent) {
        FixtureMap fixtureMap = new FixtureMap();
        fixtureMap.setFixtureName(fixtureName);
        fixtureMap.setParent(parent);
        for (Map.Entry<String, ? extends Object> entry : source.entrySet()) {
            String key = entry.getKey();
            if (entry.getValue() instanceof Map) {
                fixtureMap.put(entry.getKey(), FixtureTemplateWrapper.wrap((Map)entry.getValue(), key, (FixtureTemplate)fixtureMap));
                continue;
            }
            if (entry.getValue() instanceof List) {
                fixtureMap.put(entry.getKey(), FixtureTemplateWrapper.wrap((List)entry.getValue(), key, (FixtureTemplate)fixtureMap));
                continue;
            }
            FixtureValue wrapped = FixtureTemplateWrapper.wrap(entry.getValue(), entry.getKey(), (FixtureTemplate)fixtureMap);
            fixtureMap.put(entry.getKey(), wrapped);
        }
        return fixtureMap;
    }

    public static FixtureList wrap(List<? extends Object> source, String fixtureName, FixtureTemplate parent) {
        FixtureList fixtureList = new FixtureList();
        fixtureList.setFixtureName(fixtureName);
        fixtureList.setParent(parent);
        for (Object object : source) {
            if (object instanceof Map) {
                fixtureList.add(FixtureTemplateWrapper.wrap((Map)object, fixtureName, parent));
                continue;
            }
            if (object instanceof List) {
                fixtureList.add(FixtureTemplateWrapper.wrap((List)object, fixtureName, parent));
                continue;
            }
            fixtureList.add(FixtureTemplateWrapper.wrap(object, fixtureName, parent));
        }
        return fixtureList;
    }

    public static FixtureValue wrap(Object source, String fixtureName, FixtureTemplate parent) {
        if (source instanceof Map || source instanceof List) {
            throw new IllegalArgumentException("can not wrap Map or List type of value, use #wrap after casting");
        }
        FixtureValue fixtureValue = new FixtureValue(source);
        fixtureValue.setFixtureName(fixtureName);
        fixtureValue.setParent(parent);
        return fixtureValue;
    }
}

