/*
 * Decompiled with CFR 0.152.
 */
package io.beanmother.core.loader;

public class Location {
    private static final String CLASSPATH_SCHEME = "classpath:";
    private static final String FILESYSTEM_SCHEME = "filesystem:";
    private String scheme;
    private String path;

    public Location(String path) {
        this.assignSchemeAndPath(path);
    }

    public String getDescriptor() {
        return this.scheme + this.path;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isClasspath() {
        return CLASSPATH_SCHEME.equals(this.scheme);
    }

    public boolean isFilesystemPath() {
        return FILESYSTEM_SCHEME.equals(this.scheme);
    }

    public String toString() {
        return this.getDescriptor();
    }

    public int hashCode() {
        return this.getDescriptor().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    private void assignSchemeAndPath(String path) {
        String normalizedPath = path.trim().replace("\\", "/");
        int pathStartIndex = normalizedPath.indexOf(":");
        this.scheme = pathStartIndex == -1 ? CLASSPATH_SCHEME : normalizedPath.substring(0, pathStartIndex + 1);
        this.path = normalizedPath.substring(pathStartIndex + 1);
        if (this.path.endsWith("/")) {
            this.path = this.path.substring(0, path.length() - 1);
        }
        if (!this.isClasspath() && !this.isFilesystemPath()) {
            throw new IllegalArgumentException(path + " is unknown path, must be either 'filesystem:' or 'classpath:'");
        }
    }
}

