/*
 * Decompiled with CFR 0.152.
 */
package io.beanmother.core.loader.scanner;

import io.beanmother.core.loader.Location;
import io.beanmother.core.loader.scanner.FixtureScanner;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public abstract class AbstractFixtureScanner
implements FixtureScanner {
    private static Logger logger = Logger.getLogger(AbstractFixtureScanner.class.getName());
    private ClassLoader classLoader;

    AbstractFixtureScanner(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public List<File> scan(Location location) {
        String path = this.getAbsolutePath(location);
        if (path == null) {
            logger.warning(location.getDescriptor() + " is ignored, because it does not exist.");
            return new ArrayList<File>();
        }
        Set<File> files = this.listOfAllFixtureFiles(path);
        return new ArrayList<File>(files);
    }

    protected boolean isFixtureFile(File file) {
        return true;
    }

    private String getAbsolutePath(Location location) {
        if (location.isClasspath()) {
            URL url = this.classLoader.getResource(location.getPath());
            if (url == null) {
                return null;
            }
            return url.getFile();
        }
        if (location.isFilesystemPath()) {
            File file = new File(location.getPath());
            if (!file.exists()) {
                return null;
            }
            return file.getAbsolutePath();
        }
        return null;
    }

    private Set<File> listOfAllFixtureFiles(File file) {
        HashSet<File> files = new HashSet<File>();
        if (file.isDirectory()) {
            File[] filesInDic = file.listFiles();
            if (filesInDic == null) {
                return files;
            }
            for (File sub : filesInDic) {
                if (sub.isDirectory()) {
                    files.addAll(this.listOfAllFixtureFiles(sub));
                    continue;
                }
                if (!this.isFixtureFile(sub)) continue;
                files.add(sub);
            }
        } else if (this.isFixtureFile(file)) {
            files.add(file);
        }
        return files;
    }

    private Set<File> listOfAllFixtureFiles(String path) {
        return this.listOfAllFixtureFiles(new File(path));
    }
}

