/*
 * Decompiled with CFR 0.152.
 */
package io.beanmother.core.loader.store;

import io.beanmother.core.common.FixtureMap;
import io.beanmother.core.loader.Location;
import io.beanmother.core.loader.parser.FixtureParser;
import io.beanmother.core.loader.parser.YamlFixtureParser;
import io.beanmother.core.loader.scanner.FixtureScanner;
import io.beanmother.core.loader.scanner.YamlFixtureScanner;
import io.beanmother.core.loader.store.FixturesStore;
import io.beanmother.core.mapper.DefaultFixtureMapper;
import io.beanmother.core.util.ClassUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFixturesStore
implements FixturesStore {
    private static final Logger logger = LoggerFactory.getLogger(DefaultFixtureMapper.class);
    private FixtureScanner fixtureScanner;
    private FixtureParser fixtureParser;
    private Set<Location> fixtureLocations;
    private Set<File> fixtureFiles;
    private Map<String, FixtureMap> fixtureMaps;

    public DefaultFixturesStore() {
        this(new YamlFixtureScanner(ClassUtils.getDefaultClassLoader()), new YamlFixtureParser());
    }

    public DefaultFixturesStore(FixtureScanner fixtureScanner, FixtureParser fixtureParser) {
        this.fixtureScanner = fixtureScanner;
        this.fixtureParser = fixtureParser;
        this.reset();
    }

    @Override
    public FixtureMap get(String fixtureKey) {
        return this.fixtureMaps.get(fixtureKey);
    }

    @Override
    public FixtureMap reproduce(String fixtureKey) {
        FixtureMap fixtureMap = this.get(fixtureKey);
        if (fixtureMap == null) {
            throw new IllegalArgumentException("can not find " + fixtureKey);
        }
        return fixtureMap.reproduce();
    }

    @Override
    public boolean exists(String fixtureKey) {
        return this.fixtureMaps.containsKey(fixtureKey);
    }

    @Override
    public void addLocation(Location location) {
        if (this.fixtureLocations.contains(location)) {
            logger.debug(location.getDescriptor() + " is already added.");
            return;
        }
        List<File> files = this.fixtureScanner.scan(location);
        if (files.size() == 0) {
            logger.warn("can not find any fixture file in " + location.getDescriptor());
            return;
        }
        HashMap<String, FixtureMap> parsed = new HashMap<String, FixtureMap>();
        for (File file : files) {
            if (this.fixtureFiles.contains(file)) continue;
            String fixtureStr = null;
            try {
                fixtureStr = new String(Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0])));
            }
            catch (IOException e) {
                throw new RuntimeException("can not read " + file.getAbsolutePath(), e);
            }
            parsed.putAll(this.fixtureParser.parse(fixtureStr));
        }
        this.fixtureFiles.addAll(files);
        this.fixtureLocations.add(location);
        this.fixtureMaps.putAll(parsed);
    }

    @Override
    public void reset() {
        this.fixtureLocations = new HashSet<Location>();
        this.fixtureFiles = new HashSet<File>();
        this.fixtureMaps = new HashMap<String, FixtureMap>();
    }

    public Set<Location> getFixtureLocations() {
        return this.fixtureLocations;
    }

    public Set<File> getFixtureFiles() {
        return this.fixtureFiles;
    }

    public Map<String, FixtureMap> getFixtureMaps() {
        return this.fixtureMaps;
    }
}

