/*
 * Decompiled with CFR 0.152.
 */
package io.beanmother.core.mapper;

import com.google.common.reflect.TypeToken;
import io.beanmother.core.common.FixtureList;
import io.beanmother.core.common.FixtureMap;
import io.beanmother.core.common.FixtureTemplate;
import io.beanmother.core.common.FixtureValue;
import io.beanmother.core.mapper.FixtureConverter;
import io.beanmother.core.mapper.FixtureMappingException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;

public abstract class ConstructHelper {
    private static final String CONSTRUCT_KEY = "_construct";

    public static Object construct(Class<?> type, FixtureMap fixtureMap, FixtureConverter fixtureConverter) {
        Constructor<?>[] constructs = type.getConstructors();
        if (constructs.length == 0) {
            throw new UnsupportedOperationException("can not create an instance. " + type + " does not have a constructor.");
        }
        Object newInstance = null;
        if (fixtureMap.containsKey(CONSTRUCT_KEY)) {
            FixtureTemplate constructorFixture = (FixtureTemplate)fixtureMap.get(CONSTRUCT_KEY);
            if (constructorFixture instanceof FixtureValue) {
                newInstance = ConstructHelper.constructByFixtureValue(type, (FixtureValue)constructorFixture, fixtureConverter);
            } else if (constructorFixture instanceof FixtureList) {
                newInstance = ConstructHelper.constructByFixtureList(type, (FixtureList)constructorFixture, fixtureConverter);
            }
        }
        if (newInstance == null) {
            try {
                newInstance = type.newInstance();
            }
            catch (Exception e) {
                throw new FixtureMappingException(type, fixtureMap, e);
            }
        }
        return newInstance;
    }

    private static Object constructByFixtureList(Class<?> type, FixtureList fixtureList, FixtureConverter fixtureConverter) {
        ArrayList candidates = new ArrayList();
        for (Constructor<?> constructor : type.getConstructors()) {
            if (constructor.getParameterTypes().length != fixtureList.size()) continue;
            candidates.add(constructor);
        }
        for (Constructor constructor : candidates) {
            Object param;
            ArrayList<Object> params = new ArrayList<Object>();
            Class<?>[] paramTypes = constructor.getParameterTypes();
            for (int i = 0; i < paramTypes.length && (param = fixtureConverter.convert((FixtureTemplate)fixtureList.get(i), TypeToken.of(paramTypes[i]))) != null; ++i) {
                params.add(param);
            }
            if (params.size() != paramTypes.length) continue;
            try {
                return constructor.newInstance(params.toArray());
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private static Object constructByFixtureValue(Class<?> type, FixtureValue fixtureValue, FixtureConverter fixtureConverter) {
        for (Constructor<?> constructor : type.getConstructors()) {
            Object param;
            if (constructor.getParameterTypes().length != 1 || (param = fixtureConverter.convert(fixtureValue, TypeToken.of(constructor.getParameterTypes()[0]))) == null) continue;
            try {
                return constructor.newInstance(param);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

