/*
 * Decompiled with CFR 0.152.
 */
package io.beanmother.core.mapper;

import com.google.common.base.Optional;
import com.google.common.reflect.TypeToken;
import io.beanmother.core.common.FixtureList;
import io.beanmother.core.common.FixtureMap;
import io.beanmother.core.common.FixtureTemplate;
import io.beanmother.core.common.FixtureTemplateSubTypeHandler;
import io.beanmother.core.common.FixtureValue;
import io.beanmother.core.converter.Converter;
import io.beanmother.core.converter.ConverterFactory;
import io.beanmother.core.mapper.ConstructHelper;
import io.beanmother.core.mapper.FixtureConverter;
import io.beanmother.core.mapper.FixtureMapper;
import io.beanmother.core.mapper.FixtureMappingException;
import io.beanmother.core.mapper.MapperMediator;
import io.beanmother.core.util.ClassUtils;
import io.beanmother.core.util.PrimitiveTypeUtils;
import io.beanmother.core.util.TypeTokenUtils;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixtureConverterImpl
implements FixtureConverter {
    private static final Logger logger = LoggerFactory.getLogger(FixtureConverterImpl.class);
    private static final String java8OptionalConverterKlass = "io.beanmother.java8.converter.OptionalTypeFixtureConverter";
    private static final String guavaOptionalConverterKlass = "io.beanmother.guava.converter.OptionalTypeFixtureConverter";
    private MapperMediator mapperMediator;
    private ConverterFactory converterFactory;

    public FixtureConverterImpl(MapperMediator mapperMediator, ConverterFactory converterFactory) {
        this.mapperMediator = mapperMediator;
        this.converterFactory = converterFactory;
    }

    public Object convert(FixtureTemplate fixtureTemplate, final TypeToken typeToken) {
        FixtureConverter optionalConverter;
        if (this.isJava8OptionalTypeToken(typeToken) && (optionalConverter = this.loadJava8OptionalConverter()) != null) {
            return optionalConverter.convert(fixtureTemplate, typeToken);
        }
        if (this.isGuavaOptionalTypeToken(typeToken) && (optionalConverter = this.loadGuavaOptionalConverter()) != null) {
            return optionalConverter.convert(fixtureTemplate, typeToken);
        }
        final Object[] converted = new Object[1];
        new FixtureTemplateSubTypeHandler(){

            @Override
            protected void handleIf(FixtureMap fixtureMap) {
                converted[0] = FixtureConverterImpl.this.convert(fixtureMap, typeToken);
            }

            @Override
            protected void handleIf(FixtureList fixtureList) {
                converted[0] = FixtureConverterImpl.this.convert(fixtureList, typeToken);
            }

            @Override
            protected void handleIf(FixtureValue fixtureValue) {
                converted[0] = FixtureConverterImpl.this.convert(fixtureValue, typeToken);
            }
        }.handle(fixtureTemplate);
        return converted[0];
    }

    public ConverterFactory getConverterFactory() {
        return this.converterFactory;
    }

    public MapperMediator getMapperMediator() {
        return this.mapperMediator;
    }

    public FixtureMapper getFixtureMapper() {
        return this.getMapperMediator().getFixtureMapper();
    }

    protected Object convert(FixtureValue fixtureValue, TypeToken<?> typeToken) {
        if (typeToken.isPrimitive()) {
            Class<?> wrapperClass = PrimitiveTypeUtils.toWrapper((Class)typeToken.getType());
            typeToken = TypeToken.of(wrapperClass);
        }
        Object source = fixtureValue.getValue();
        Converter convert = this.getConverterFactory().get(source, typeToken);
        if (convert != null) {
            return convert.convert(source, typeToken);
        }
        return null;
    }

    protected Object convert(FixtureList fixtureList, TypeToken<?> typeToken) {
        List<Object> convertedList;
        boolean isArray = typeToken.isArray();
        boolean isList = typeToken.isSubtypeOf(TypeToken.of(List.class));
        boolean isSet = typeToken.isSubtypeOf(TypeToken.of(Set.class));
        if (!(isList || isArray || isSet)) {
            throw new FixtureMappingException("Target setter of '" + fixtureList.getFixtureName() + "' must be List, Set or array.");
        }
        if (isArray || typeToken.getRawType().isInterface()) {
            convertedList = new ArrayList();
        } else {
            try {
                convertedList = (List)typeToken.getRawType().newInstance();
            }
            catch (Exception e) {
                throw new FixtureMappingException(e);
            }
        }
        TypeToken<?> elementTypeToken = TypeTokenUtils.extractElementTypeToken(typeToken);
        for (FixtureTemplate template : fixtureList) {
            Object converted = this.convert(template, (TypeToken)elementTypeToken);
            if (converted != null) {
                convertedList.add(converted);
                continue;
            }
            logger.warn("Can not find converter for " + fixtureList.getFixtureName());
        }
        if (convertedList.size() == 0) {
            return null;
        }
        if (isArray) {
            if (elementTypeToken.isPrimitive()) {
                return PrimitiveTypeUtils.toWrapperListToPrimitiveArray(convertedList, (Class)elementTypeToken.getType());
            }
            return Arrays.copyOf(convertedList.toArray(), convertedList.size(), typeToken.getRawType());
        }
        if (isSet) {
            HashSet<Object> set = new HashSet<Object>();
            set.addAll(convertedList);
            return set;
        }
        return convertedList;
    }

    protected Object convert(FixtureMap fixtureMap, TypeToken<?> typeToken) {
        if (typeToken.isSubtypeOf(Map.class)) {
            Map<Object, Object> convertedMap;
            TypeToken<?> valueTypeToken;
            TypeToken<?> keyTypeToken;
            List<TypeToken<?>> keyValueTypeTokens = TypeTokenUtils.extractGenericTypeTokens(typeToken);
            if (keyValueTypeTokens.size() == 2) {
                keyTypeToken = keyValueTypeTokens.get(0);
                valueTypeToken = keyValueTypeTokens.get(1);
            } else {
                keyTypeToken = TypeToken.of(Object.class);
                valueTypeToken = TypeToken.of(Object.class);
            }
            if (typeToken.getRawType().isInterface()) {
                convertedMap = new LinkedHashMap();
            } else {
                try {
                    convertedMap = (Map)typeToken.getRawType().newInstance();
                }
                catch (Exception e) {
                    throw new FixtureMappingException(e);
                }
            }
            for (Map.Entry entry : fixtureMap.entrySet()) {
                Object key = this.convert(new FixtureValue(entry.getKey()), keyTypeToken);
                Object converted = this.convert((FixtureTemplate)entry.getValue(), (TypeToken)valueTypeToken);
                convertedMap.put(key, converted);
            }
            return convertedMap;
        }
        Object obj = null;
        try {
            obj = ConstructHelper.construct(typeToken.getRawType(), fixtureMap, this);
        }
        catch (Exception e) {
            throw new FixtureMappingException(e);
        }
        this.getFixtureMapper().map(fixtureMap, obj);
        return obj;
    }

    private boolean isJava8OptionalTypeToken(TypeToken<?> typeToken) {
        String name = typeToken.getRawType().getName();
        return typeToken.getRawType().getName().equals("java.util.Optional");
    }

    private boolean isGuavaOptionalTypeToken(TypeToken<?> typeToken) {
        return typeToken.getRawType().equals(Optional.class);
    }

    private FixtureConverter loadFixtureConverter(String className) {
        try {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = ClassUtils.getDefaultClassLoader().loadClass(className).getConstructors()) {
                if (constructor.getParameterTypes().length != 1 || constructor.getParameterTypes()[0] != FixtureConverter.class) continue;
                try {
                    return (FixtureConverter)constructor.newInstance(this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private FixtureConverter loadJava8OptionalConverter() {
        return this.loadFixtureConverter(java8OptionalConverterKlass);
    }

    private FixtureConverter loadGuavaOptionalConverter() {
        return this.loadFixtureConverter(guavaOptionalConverterKlass);
    }
}

