/*
 * Decompiled with CFR 0.152.
 */
package io.beanmother.core.mapper;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.Parameter;
import com.google.common.reflect.TypeToken;
import io.beanmother.core.common.FixtureList;
import io.beanmother.core.common.FixtureMap;
import io.beanmother.core.common.FixtureTemplate;
import io.beanmother.core.common.FixtureValue;
import io.beanmother.core.mapper.AbstractFixtureMapper;
import io.beanmother.core.mapper.FixtureMapper;
import io.beanmother.core.mapper.FixtureMappingException;
import io.beanmother.core.mapper.MapperMediator;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetterAndFieldFixtureMapper
extends AbstractFixtureMapper
implements FixtureMapper {
    private static final Logger logger = LoggerFactory.getLogger(SetterAndFieldFixtureMapper.class);
    private static final String SETTER_PREFIX = "set";

    public SetterAndFieldFixtureMapper(MapperMediator mapperMediator) {
        super(mapperMediator);
    }

    @Override
    protected void bind(Object target, String key, FixtureMap fixtureMap) {
        List<Method> candidates = this.findSetterCandidates(target, key);
        for (Method candidate : candidates) {
            ImmutableList paramTypes = Invokable.from((Method)candidate).getParameters();
            if (paramTypes.size() != 1) continue;
            TypeToken paramType = ((Parameter)paramTypes.get(0)).getType();
            try {
                Object candidateParam = this.getFixtureConverter().convert(fixtureMap, paramType);
                if (candidateParam == null) continue;
                candidate.invoke(target, candidateParam);
                return;
            }
            catch (Exception e) {
                throw new FixtureMappingException(e);
            }
        }
        this.bindByField(target, key, fixtureMap);
    }

    @Override
    protected void bind(Object target, String key, FixtureList fixtureList) {
        List<Method> candidates = this.findSetterCandidates(target, key);
        for (Method candidate : candidates) {
            try {
                ImmutableList paramTypes = Invokable.from((Method)candidate).getParameters();
                if (paramTypes.size() != 1) continue;
                TypeToken paramType = ((Parameter)paramTypes.get(0)).getType();
                Object candidateParam = this.getFixtureConverter().convert(fixtureList, paramType);
                if (candidateParam == null) continue;
                candidate.invoke(target, candidateParam);
                return;
            }
            catch (Exception e) {
                throw new FixtureMappingException(e);
            }
        }
        this.bindByField(target, key, fixtureList);
    }

    @Override
    protected void bind(Object target, String key, FixtureValue fixtureValue) {
        if (fixtureValue == null || fixtureValue.isNull()) {
            return;
        }
        List<Method> candidates = this.findSetterCandidates(target, key);
        for (Method candidate : candidates) {
            ImmutableList paramTypes = Invokable.from((Method)candidate).getParameters();
            if (paramTypes == null || paramTypes.size() != 1) continue;
            TypeToken paramType = ((Parameter)paramTypes.get(0)).getType();
            Object param = this.getFixtureConverter().convert(fixtureValue, paramType);
            if (param == null) continue;
            try {
                candidate.invoke(target, param);
            }
            catch (Exception e) {
                throw new FixtureMappingException(e);
            }
        }
        this.bindByField(target, key, fixtureValue);
    }

    private List<Method> findSetterCandidates(Object target, String key) {
        Method[] methods = target.getClass().getMethods();
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : methods) {
            String name = method.getName();
            if (name.indexOf(SETTER_PREFIX) != 0 || !name.substring(SETTER_PREFIX.length(), name.length()).equalsIgnoreCase(key)) continue;
            result.add(method);
        }
        return result;
    }

    private void bindByField(Object target, String key, FixtureTemplate template) {
        Field field = this.findField(target.getClass(), key);
        if (field == null) {
            try {
                field = target.getClass().getDeclaredField(key);
                field.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                return;
            }
        }
        TypeToken targetType = TypeToken.of((Type)field.getGenericType());
        Object value = this.getFixtureConverter().convert(template, targetType);
        if (value == null) {
            return;
        }
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw new FixtureMappingException(e);
        }
    }

    private Field findField(Class<?> targetClass, String key) {
        try {
            return targetClass.getField(key);
        }
        catch (NoSuchFieldException e) {
            Class<?> superClass = targetClass.getSuperclass();
            if (superClass == null || superClass == Object.class) {
                return null;
            }
            return this.findField(targetClass.getSuperclass(), key);
        }
    }
}

