/*
 * Decompiled with CFR 0.152.
 */
package io.beanmother.core.script;

import io.beanmother.core.script.ScriptFragment;
import io.beanmother.core.script.ScriptHandler;
import io.beanmother.core.script.ScriptRunner;
import io.beanmother.core.script.ScriptRunnerModule;
import io.beanmother.core.script.std.FakerScriptRunner;
import io.beanmother.core.script.std.SequenceScriptRunner;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DefaultScriptHandler
implements ScriptHandler {
    private Set<ScriptRunner> scriptRunners = new HashSet<ScriptRunner>();

    public DefaultScriptHandler() {
        this.scriptRunners.add(new FakerScriptRunner());
        this.scriptRunners.add(new SequenceScriptRunner());
    }

    @Override
    public Object runScript(ScriptFragment scriptFragment) {
        ScriptRunner process = this.get(scriptFragment);
        if (process == null) {
            throw new IllegalArgumentException("can not find ScriptRunner for " + scriptFragment.toScriptString());
        }
        return process.run(scriptFragment);
    }

    @Override
    public void register(ScriptRunnerModule scriptRunnerModule) {
        Iterator<ScriptRunner> elements = scriptRunnerModule.getScriptRunners().iterator();
        while (elements.hasNext()) {
            this.register(elements.next());
        }
    }

    @Override
    public void register(ScriptRunner scriptRunner) {
        this.scriptRunners.add(scriptRunner);
    }

    public ScriptRunner get(ScriptFragment scriptFragment) {
        for (ScriptRunner processor : this.scriptRunners) {
            if (!processor.canHandle(scriptFragment)) continue;
            return processor;
        }
        return null;
    }
}

