/*
 * Decompiled with CFR 0.152.
 */
package io.beanmother.core.script;

import com.google.common.reflect.TypeToken;
import io.beanmother.core.converter.Converter;
import io.beanmother.core.converter.ConverterFactory;
import io.beanmother.core.script.ScriptFragment;
import io.beanmother.core.script.ScriptOperationException;
import io.beanmother.core.script.ScriptRunner;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.naming.OperationNotSupportedException;

public abstract class MethodReflectionEvalScriptRunner
implements ScriptRunner {
    private static final ConverterFactory converterFactory = new ConverterFactory();

    public abstract Object getTargetObject();

    public abstract String getScriptNamespace();

    @Override
    public Object run(ScriptFragment scriptFragment) {
        if (!this.canHandle(scriptFragment)) {
            throw new ScriptOperationException("Fail to operate " + scriptFragment.toScriptString());
        }
        ScriptFragment mainScript = scriptFragment.getNext();
        try {
            return this.callScriptRecursively(this.getTargetObject(), mainScript);
        }
        catch (Exception e) {
            throw new ScriptOperationException("Fail to operate " + scriptFragment.toScriptString(), e);
        }
    }

    @Override
    public boolean canHandle(ScriptFragment scriptFragment) {
        return scriptFragment.getNext() != null && scriptFragment.getMethodName().equals(this.getScriptNamespace());
    }

    private Object callScriptRecursively(Object targetObj, ScriptFragment scriptFragment) throws OperationNotSupportedException {
        if (scriptFragment == null) {
            return targetObj;
        }
        Method[] methods = targetObj.getClass().getMethods();
        ArrayList<Method> targetMethods = new ArrayList<Method>();
        for (Method method : methods) {
            if (!method.getName().equals(scriptFragment.getMethodName()) || method.getParameterTypes().length != scriptFragment.getArguments().size()) continue;
            targetMethods.add(method);
        }
        for (Method targetMethod : targetMethods) {
            Class<?>[] types = targetMethod.getParameterTypes();
            ArrayList<Object> arguments = new ArrayList<Object>();
            try {
                for (int i = 0; i < types.length; ++i) {
                    arguments.add(this.convert(scriptFragment.getArguments().get(i), TypeToken.of(types[i])));
                }
                Object obj = targetMethod.invoke(targetObj, arguments.toArray());
                return this.callScriptRecursively(obj, scriptFragment.getNext());
            }
            catch (Exception e) {
            }
        }
        throw new OperationNotSupportedException("can not find " + scriptFragment.getMethodName() + " of " + targetObj.getClass());
    }

    private Object convert(Object source, TypeToken<?> typeToken) {
        Converter converter = converterFactory.get(source, typeToken);
        if (converter == null) {
            throw new IllegalArgumentException("can not convert " + source + " to the instance of " + typeToken.getRawType());
        }
        return converter.convert(source, typeToken);
    }
}

