/*
 * Decompiled with CFR 0.152.
 */
package io.beanmother.core.script;

import io.beanmother.core.common.FixtureValue;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ScriptFragment {
    private static final Pattern FIXTURE_VALUE_SCRIPT_PATTERN = Pattern.compile("(?<=\\$\\{)(.+?)(?=})");
    private static final Pattern ARGUMENTS_PATTERN = Pattern.compile("(?<=\\()(.*?)(?=\\))");
    private static final String FRAGMENT_DELIM = "\\.";
    private String methodName;
    private List<String> arguments = new ArrayList<String>();
    private ScriptFragment next;

    public static ScriptFragment of(FixtureValue fixtureValue) {
        Matcher matcher;
        if (fixtureValue.getValue() instanceof String && (matcher = FIXTURE_VALUE_SCRIPT_PATTERN.matcher((CharSequence)fixtureValue.getValue())).find()) {
            String script = matcher.group(0);
            return ScriptFragment.of(script);
        }
        throw new IllegalArgumentException(fixtureValue.toString() + " is not a script");
    }

    public static ScriptFragment of(String script) {
        String[] fragmentStrings = script.split(FRAGMENT_DELIM);
        ScriptFragment scriptFragment = null;
        for (String fragmentString : fragmentStrings) {
            if (scriptFragment == null) {
                scriptFragment = ScriptFragment.build(fragmentString);
                continue;
            }
            scriptFragment.appendToTail(ScriptFragment.build(fragmentString));
        }
        return scriptFragment;
    }

    private static ScriptFragment build(String script) {
        Matcher argumentMatcher = ARGUMENTS_PATTERN.matcher(script);
        if (argumentMatcher.find()) {
            String[] arguments = argumentMatcher.group(0).split(",");
            script = script.substring(0, script.indexOf("("));
            if (arguments.length == 1 && arguments[0].trim().length() == 0) {
                return new ScriptFragment(script);
            }
            return new ScriptFragment(script, arguments);
        }
        return new ScriptFragment(script);
    }

    public static boolean isScript(FixtureValue fixtureValue) {
        return fixtureValue.getValue() instanceof String && FIXTURE_VALUE_SCRIPT_PATTERN.matcher((CharSequence)fixtureValue.getValue()).find();
    }

    public ScriptFragment(String methodName) {
        this.methodName = methodName.trim();
    }

    public ScriptFragment(String methodName, String ... arguments) {
        this(methodName);
        for (String argument : arguments) {
            this.arguments.add(argument.trim().replaceAll("\"", "").replaceAll("'", ""));
        }
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public boolean hasArguments() {
        return this.arguments != null && !this.arguments.isEmpty();
    }

    public ScriptFragment getNext() {
        return this.next;
    }

    public void appendToTail(ScriptFragment scriptFragment) {
        if (this.next == null) {
            this.next = scriptFragment;
        } else {
            this.next.appendToTail(scriptFragment);
        }
    }

    public String toScriptString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.methodName);
        if (this.arguments != null && !this.arguments.isEmpty()) {
            builder.append("(");
            for (int i = 0; i < this.arguments.size(); ++i) {
                builder.append("'" + this.arguments.get(i) + "'");
                if (i >= this.arguments.size() - 1) continue;
                builder.append(",");
            }
            builder.append(")");
        }
        if (this.getNext() != null) {
            builder.append(".").append(this.getNext().toScriptString());
        }
        return builder.toString();
    }
}

