/*
 * Decompiled with CFR 0.152.
 */
package io.beanmother.core.util;

import com.google.common.primitives.Booleans;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Chars;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.List;

public abstract class PrimitiveTypeUtils {
    public static Class<?> toWrapper(TypeToken<?> primitiveTypeToken) {
        return PrimitiveTypeUtils.toWrapper((Class)primitiveTypeToken.getType());
    }

    public static TypeToken<?> toWrapperTypeToken(TypeToken<?> primitiveTypeToken) {
        return TypeToken.of(PrimitiveTypeUtils.toWrapper(primitiveTypeToken));
    }

    public static Class<?> toWrapper(Class<?> primitiveType) {
        if (Boolean.TYPE.equals(primitiveType)) {
            return Boolean.class;
        }
        if (Float.TYPE.equals(primitiveType)) {
            return Float.class;
        }
        if (Long.TYPE.equals(primitiveType)) {
            return Long.class;
        }
        if (Integer.TYPE.equals(primitiveType)) {
            return Integer.class;
        }
        if (Short.TYPE.equals(primitiveType)) {
            return Short.class;
        }
        if (Byte.TYPE.equals(primitiveType)) {
            return Byte.class;
        }
        if (Double.TYPE.equals(primitiveType)) {
            return Double.class;
        }
        if (Character.TYPE.equals(primitiveType)) {
            return Character.class;
        }
        throw new IllegalArgumentException(primitiveType.getName() + " is not a supported primitive type");
    }

    public static Object toWrapperListToPrimitiveArray(List wrapperList, Class<?> primitiveType) {
        if (primitiveType.isArray()) {
            primitiveType = primitiveType.getComponentType();
        }
        if (Boolean.TYPE.equals(primitiveType)) {
            return Booleans.toArray((Collection)wrapperList);
        }
        if (Float.TYPE.equals(primitiveType)) {
            return Floats.toArray((Collection)wrapperList);
        }
        if (Long.TYPE.equals(primitiveType)) {
            return Longs.toArray((Collection)wrapperList);
        }
        if (Integer.TYPE.equals(primitiveType)) {
            return Ints.toArray((Collection)wrapperList);
        }
        if (Short.TYPE.equals(primitiveType)) {
            return Shorts.toArray((Collection)wrapperList);
        }
        if (Byte.TYPE.equals(primitiveType)) {
            return Bytes.toArray((Collection)wrapperList);
        }
        if (Double.TYPE.equals(primitiveType)) {
            return Doubles.toArray((Collection)wrapperList);
        }
        if (Character.TYPE.equals(primitiveType)) {
            return Chars.toArray((Collection)wrapperList);
        }
        throw new IllegalArgumentException(primitiveType.getName() + " is not a supported primitive type");
    }
}

