/*
 * Decompiled with CFR 0.152.
 */
package io.beanmother.core.util;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class TypeTokenUtils {
    public static TypeToken<?> extractElementTypeToken(TypeToken<?> typeToken) {
        if (typeToken.isSubtypeOf(Collection.class)) {
            List<TypeToken<?>> genericTypeTokens = TypeTokenUtils.extractGenericTypeTokens(typeToken);
            if (genericTypeTokens.size() == 0) {
                return TypeToken.of(Object.class);
            }
            return genericTypeTokens.get(0);
        }
        if (typeToken.isArray()) {
            return typeToken.getComponentType();
        }
        throw new IllegalArgumentException("typeToken must be from List or array");
    }

    public static List<TypeToken<?>> extractGenericTypeTokens(TypeToken<?> typeToken) {
        ArrayList typeTokens = new ArrayList();
        try {
            Type[] types;
            for (Type type : types = ((ParameterizedType)typeToken.getType()).getActualTypeArguments()) {
                typeTokens.add(TypeToken.of((Type)type));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return typeTokens;
    }
}

