/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.bootstrap;

import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.matcher.Matchers;
import com.mware.core.bootstrap.BootstrapBindingProvider;
import com.mware.core.bootstrap.InjectHelper;
import com.mware.core.cache.CacheService;
import com.mware.core.cache.InMemoryCacheService;
import com.mware.core.config.Configuration;
import com.mware.core.email.EmailRepository;
import com.mware.core.email.NopEmailRepository;
import com.mware.core.exception.BcException;
import com.mware.core.lifecycle.LifeSupportService;
import com.mware.core.lifecycle.LifecycleListener;
import com.mware.core.lifecycle.LifecycleStatus;
import com.mware.core.model.file.FileSystemRepository;
import com.mware.core.model.file.LocalFileSystemRepository;
import com.mware.core.model.lock.LockRepository;
import com.mware.core.model.lock.SingleJvmLockRepository;
import com.mware.core.model.longRunningProcess.GeLongRunningProcessRepository;
import com.mware.core.model.longRunningProcess.LongRunningProcessRepository;
import com.mware.core.model.regex.GeRegexRepository;
import com.mware.core.model.regex.RegexRepository;
import com.mware.core.model.role.AuthorizationRepository;
import com.mware.core.model.role.GeAuthorizationRepository;
import com.mware.core.model.schema.GeSchemaRepository;
import com.mware.core.model.schema.SchemaRepository;
import com.mware.core.model.search.GeSearchRepository;
import com.mware.core.model.search.SearchRepository;
import com.mware.core.model.user.GeUserRepository;
import com.mware.core.model.user.GraphAuthorizationRepository;
import com.mware.core.model.user.InMemoryGraphAuthorizationRepository;
import com.mware.core.model.user.InMemoryUserSessionCounterRepository;
import com.mware.core.model.user.PrivilegeRepository;
import com.mware.core.model.user.UserPropertyPrivilegeRepository;
import com.mware.core.model.user.UserRepository;
import com.mware.core.model.user.UserSessionCounterRepository;
import com.mware.core.model.workQueue.InMemoryWebQueueRepository;
import com.mware.core.model.workQueue.InMemoryWorkQueueRepository;
import com.mware.core.model.workQueue.WebQueueRepository;
import com.mware.core.model.workQueue.WorkQueueRepository;
import com.mware.core.model.workspace.GeWorkspaceRepository;
import com.mware.core.model.workspace.WorkspaceRepository;
import com.mware.core.orm.SimpleOrmSession;
import com.mware.core.orm.graph.GraphSimpleOrmSession;
import com.mware.core.security.AuditService;
import com.mware.core.security.DirectVisibilityTranslator;
import com.mware.core.security.LoggingAuditService;
import com.mware.core.security.VisibilityTranslator;
import com.mware.core.status.InMemoryStatusRepository;
import com.mware.core.status.JmxMetricsManager;
import com.mware.core.status.MetricsManager;
import com.mware.core.status.StatusRepository;
import com.mware.core.time.TimeRepository;
import com.mware.core.trace.DefaultTraceRepository;
import com.mware.core.trace.TraceRepository;
import com.mware.core.trace.Traced;
import com.mware.core.trace.TracedMethodInterceptor;
import com.mware.core.user.User;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.core.util.ClassUtil;
import com.mware.core.util.ServiceLoaderUtil;
import com.mware.core.watcher.WatcherGraphListener;
import com.mware.ge.Graph;
import com.mware.ge.GraphFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;

public class BcBootstrap
extends AbstractModule
implements LifecycleListener {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(BcBootstrap.class);
    private static final String GRAPH_METADATA_GRAPH_VERSION_KEY = "graph.version";
    private static final Integer GRAPH_METADATA_GRAPH_VERSION = 3;
    private static BcBootstrap bcBootstrap;
    private final Configuration configuration;

    public static synchronized BcBootstrap bootstrap(Configuration configuration) {
        if (bcBootstrap == null) {
            LOGGER.debug("Initializing BcBootstrap with Configuration:\n%s", configuration);
            bcBootstrap = new BcBootstrap(configuration);
        }
        return bcBootstrap;
    }

    public static InjectHelper.ModuleMaker bootstrapModuleMaker(final Configuration configuration) {
        return new InjectHelper.ModuleMaker(){

            @Override
            public Module createModule() {
                return BcBootstrap.bootstrap(configuration);
            }

            @Override
            public Configuration getConfiguration() {
                return configuration;
            }
        };
    }

    private BcBootstrap(Configuration config) {
        this.configuration = config;
    }

    protected void configure() {
        LOGGER.info("Configuring BcBootstrap.", new Object[0]);
        Preconditions.checkNotNull((Object)this.configuration, (Object)"configuration cannot be null");
        this.bind(Configuration.class).toInstance((Object)this.configuration);
        LOGGER.debug("binding %s", JmxMetricsManager.class.getName());
        JmxMetricsManager metricsManager = new JmxMetricsManager();
        this.bind(MetricsManager.class).toInstance((Object)metricsManager);
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(Traced.class), new MethodInterceptor[]{new TracedMethodInterceptor()});
        this.bind(TraceRepository.class).toProvider(BcBootstrap.getConfigurableProvider(this.configuration, "repository.trace", DefaultTraceRepository.class)).in(Scopes.SINGLETON);
        this.bind(Graph.class).toProvider(this.getGraphProvider(this.configuration, "graph")).in(Scopes.SINGLETON);
        this.bind(LockRepository.class).toProvider(BcBootstrap.getConfigurableProvider(this.configuration, "repository.lock", SingleJvmLockRepository.class)).in(Scopes.SINGLETON);
        this.bind(WorkQueueRepository.class).toProvider(BcBootstrap.getConfigurableProvider(this.configuration, "repository.workQueue", InMemoryWorkQueueRepository.class)).in(Scopes.SINGLETON);
        this.bind(WebQueueRepository.class).toProvider(BcBootstrap.getConfigurableProvider(this.configuration, "repository.webQueue", InMemoryWebQueueRepository.class)).in(Scopes.SINGLETON);
        this.bind(LongRunningProcessRepository.class).toProvider(BcBootstrap.getConfigurableProvider(this.configuration, "repository.longRunningProcess", GeLongRunningProcessRepository.class)).in(Scopes.SINGLETON);
        this.bind(VisibilityTranslator.class).toProvider(BcBootstrap.getConfigurableProvider(this.configuration, "security.visibilityTranslator", DirectVisibilityTranslator.class)).in(Scopes.SINGLETON);
        this.bind(UserRepository.class).toProvider(BcBootstrap.getConfigurableProvider(this.configuration, "repository.user", GeUserRepository.class)).in(Scopes.SINGLETON);
        this.bind(UserSessionCounterRepository.class).toProvider(BcBootstrap.getConfigurableProvider(this.configuration, "repository.userSessionCounter", InMemoryUserSessionCounterRepository.class)).in(Scopes.SINGLETON);
        this.bind(WorkspaceRepository.class).toProvider(BcBootstrap.getConfigurableProvider(this.configuration, "repository.workspace", GeWorkspaceRepository.class)).in(Scopes.SINGLETON);
        this.bind(GraphAuthorizationRepository.class).toProvider(BcBootstrap.getConfigurableProvider(this.configuration, "repository.graphAuthorization", InMemoryGraphAuthorizationRepository.class)).in(Scopes.SINGLETON);
        this.bind(SchemaRepository.class).toProvider(BcBootstrap.getConfigurableProvider(this.configuration, "repository.ontology", GeSchemaRepository.class)).in(Scopes.SINGLETON);
        this.bind(SimpleOrmSession.class).toProvider(BcBootstrap.getConfigurableProvider(this.configuration, "simpleOrmSession", GraphSimpleOrmSession.class)).in(Scopes.SINGLETON);
        this.bind(EmailRepository.class).toProvider(BcBootstrap.getConfigurableProvider(this.configuration, "repository.email", NopEmailRepository.class)).in(Scopes.SINGLETON);
        this.bind(StatusRepository.class).toProvider(BcBootstrap.getConfigurableProvider(this.configuration, "repository.status", InMemoryStatusRepository.class)).in(Scopes.SINGLETON);
        this.bind(FileSystemRepository.class).toProvider(BcBootstrap.getConfigurableProvider(this.configuration, "repository.fileSystem", LocalFileSystemRepository.class)).in(Scopes.SINGLETON);
        this.bind(AuthorizationRepository.class).toProvider(BcBootstrap.getConfigurableProvider(this.configuration, "repository.authorization", GeAuthorizationRepository.class)).in(Scopes.SINGLETON);
        this.bind(PrivilegeRepository.class).toProvider(BcBootstrap.getConfigurableProvider(this.configuration, "repository.privilege", UserPropertyPrivilegeRepository.class)).in(Scopes.SINGLETON);
        this.bind(AuditService.class).toProvider(BcBootstrap.getConfigurableProvider(this.configuration, "service.audit", LoggingAuditService.class)).in(Scopes.SINGLETON);
        this.bind(TimeRepository.class).toInstance((Object)new TimeRepository());
        this.bind(RegexRepository.class).toProvider(BcBootstrap.getConfigurableProvider(this.configuration, "repository.regex", GeRegexRepository.class)).in(Scopes.SINGLETON);
        this.bind(CacheService.class).toProvider(BcBootstrap.getConfigurableProvider(this.configuration, "service.cache", InMemoryCacheService.class)).in(Scopes.SINGLETON);
        this.bind(SearchRepository.class).toProvider(BcBootstrap.getConfigurableProvider(this.configuration, null, GeSearchRepository.class)).in(Scopes.SINGLETON);
        this.injectProviders();
    }

    private Provider<? extends Graph> getGraphProvider(Configuration configuration, String configurationPrefix) {
        Map<String, String> configurationSubset = configuration.getSubset(configurationPrefix);
        return () -> {
            Graph g;
            try {
                LOGGER.debug("creating graph", new Object[0]);
                g = new GraphFactory().createGraph(configurationSubset);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create graph", e);
            }
            this.checkGraphVersion(g);
            if (configuration.getBoolean("watcher.enabled", false)) {
                g.addGraphEventListener(new WatcherGraphListener());
            }
            this.getLifeSupportService().addLifecycleListener((instance, from, to) -> {
                if (to == LifecycleStatus.SHUTDOWN) {
                    g.shutdown();
                }
            });
            this.getLifeSupportService().addLifecycleListener(this);
            this.getLifeSupportService().start();
            return g;
        };
    }

    private LifeSupportService getLifeSupportService() {
        return InjectHelper.getInstance(LifeSupportService.class);
    }

    public void checkGraphVersion(Graph g) {
        Object graphVersionObj = g.getMetadata(GRAPH_METADATA_GRAPH_VERSION_KEY);
        if (graphVersionObj == null) {
            g.setMetadata(GRAPH_METADATA_GRAPH_VERSION_KEY, GRAPH_METADATA_GRAPH_VERSION);
        } else if (graphVersionObj instanceof Integer) {
            Integer graphVersion = (Integer)graphVersionObj;
            if (!GRAPH_METADATA_GRAPH_VERSION.equals(graphVersion)) {
                throw new BcException("Invalid graph.version expected " + GRAPH_METADATA_GRAPH_VERSION + " found " + graphVersion);
            }
        } else {
            throw new BcException("Invalid graph.version expected Integer found " + graphVersionObj.getClass().getName());
        }
    }

    private void injectProviders() {
        LOGGER.info("Running %s", BootstrapBindingProvider.class.getName());
        Iterable<BootstrapBindingProvider> bindingProviders = ServiceLoaderUtil.loadWithoutInjecting(BootstrapBindingProvider.class, this.configuration);
        for (BootstrapBindingProvider provider : bindingProviders) {
            LOGGER.debug("Configuring bindings from BootstrapBindingProvider: %s", provider.getClass().getName());
            provider.addBindings(this.binder(), this.configuration);
        }
    }

    public static void shutdown() {
        bcBootstrap = null;
    }

    public static <T> Provider<? extends T> getConfigurableProvider(Configuration config, String key, String defaultClass) {
        return BcBootstrap.getConfigurableProvider(config, key, ClassUtil.forName(defaultClass));
    }

    public static <T> Provider<? extends T> getConfigurableProvider(Configuration config, String key, Class<T> defaultClass) {
        Class<T> configuredClass = config.getClass(key, defaultClass);
        return configuredClass != null ? new ConfigurableProvider<T>(configuredClass, config, key, null) : new NullProvider();
    }

    @Override
    public void lifeStatusChanged(Object instance, LifecycleStatus from, LifecycleStatus to) {
        if (LifecycleStatus.SHUTDOWN == to) {
            LOGGER.info("Shutdown: InjectHelper", new Object[0]);
            InjectHelper.shutdown();
            LOGGER.info("Shutdown: BcBootstrap", new Object[0]);
            BcBootstrap.shutdown();
        }
    }

    private static class ConfigurableProvider<T>
    implements Provider<T> {
        private final Class<? extends T> clazz;
        private final Method initMethod;
        private final Object[] initMethodArgs;
        private final Configuration config;
        private final String keyPrefix;

        public ConfigurableProvider(Class<? extends T> clazz, Configuration config, String keyPrefix, User user) {
            this.config = config;
            this.keyPrefix = keyPrefix;
            Object[] initArgs = null;
            Method init = this.findInit(clazz, Configuration.class, User.class);
            if (init != null) {
                initArgs = new Object[]{config, user};
            } else {
                init = this.findInit(clazz, Map.class, User.class);
                if (init != null) {
                    initArgs = new Object[]{config.toMap(), user};
                } else {
                    init = this.findInit(clazz, Configuration.class);
                    if (init != null) {
                        initArgs = new Object[]{config};
                    } else {
                        init = this.findInit(clazz, Map.class);
                        if (init != null) {
                            initArgs = new Object[]{config.toMap()};
                        }
                    }
                }
            }
            this.clazz = clazz;
            this.initMethod = init;
            this.initMethodArgs = initArgs;
        }

        private Method findInit(Class<? extends T> target, Class<?> ... paramTypes) {
            try {
                return target.getMethod("init", paramTypes);
            }
            catch (NoSuchMethodException ex) {
                return null;
            }
            catch (SecurityException ex) {
                ArrayList<String> paramNames = new ArrayList<String>();
                for (Class<?> pc : paramTypes) {
                    paramNames.add(pc.getSimpleName());
                }
                throw new BcException(String.format("Error accessing init(%s) method in %s.", paramNames, this.clazz.getName()), ex);
            }
        }

        public T get() {
            Exception error;
            try {
                T impl;
                LOGGER.debug("creating %s", this.clazz.getName());
                if (InjectHelper.getInjector() != null) {
                    impl = InjectHelper.getInstance(this.clazz);
                } else {
                    Constructor<T> constructor = this.clazz.getConstructor(new Class[0]);
                    impl = constructor.newInstance(new Object[0]);
                }
                if (this.initMethod != null) {
                    this.initMethod.invoke(impl, this.initMethodArgs);
                }
                this.config.setConfigurables(impl, this.keyPrefix);
                return impl;
            }
            catch (IllegalAccessException iae) {
                LOGGER.error("Unable to access default constructor for %s", this.clazz.getName(), iae);
                error = iae;
            }
            catch (IllegalArgumentException iae) {
                LOGGER.error("Unable to initialize instance of %s.", this.clazz.getName(), iae);
                error = iae;
            }
            catch (InvocationTargetException ite) {
                LOGGER.error("Error initializing instance of %s.", this.clazz.getName(), ite);
                error = ite;
            }
            catch (NoSuchMethodException e) {
                LOGGER.error("Could not find constructor for %s.", this.clazz.getName(), e);
                error = e;
            }
            catch (InstantiationException e) {
                LOGGER.error("Could not create %s.", this.clazz.getName(), e);
                error = e;
            }
            throw new BcException(String.format("Unable to initialize instance of %s", this.clazz.getName()), error);
        }
    }

    private static class NullProvider<T>
    implements Provider<T> {
        private NullProvider() {
        }

        public T get() {
            return null;
        }
    }
}

