/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.bootstrap;

import com.fasterxml.jackson.module.guice.ObjectMapperModule;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.ProvisionException;
import com.mware.core.config.Configuration;
import com.mware.core.exception.BcException;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.core.util.ServiceLoaderUtil;
import com.mware.ge.util.IterableUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InjectHelper {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(InjectHelper.class);
    private static Injector injector;

    public static <T> T inject(T o, ModuleMaker moduleMaker, Configuration configuration) {
        InjectHelper.ensureInjectorCreated(moduleMaker, configuration);
        InjectHelper.inject(o);
        return o;
    }

    public static <T> T inject(T o) {
        if (injector == null) {
            throw new BcException("Could not find injector");
        }
        injector.injectMembers(o);
        return o;
    }

    public static Injector getInjector() {
        return injector;
    }

    public static <T> T getInstance(Class<T> clazz, ModuleMaker moduleMaker, Configuration configuration) {
        InjectHelper.ensureInjectorCreated(moduleMaker, configuration);
        return (T)injector.getInstance(clazz);
    }

    public static <T> T getInstance(Class<? extends T> clazz) {
        LOGGER.debug("getInstance of class: " + clazz.getName(), new Object[0]);
        if (injector == null) {
            throw new BcException("Could not find injector");
        }
        try {
            return (T)injector.getInstance(clazz);
        }
        catch (ProvisionException ex) {
            LOGGER.error("Could not create class: %s: %s", new Object[]{clazz.getName(), ex.getMessage(), ex});
            throw new BcException("Could not create class: " + clazz.getName(), ex);
        }
        catch (Throwable ex) {
            throw new BcException("Could not create class: " + clazz.getName(), ex);
        }
    }

    public static <T> Collection<T> getInjectedServices(Class<T> clazz, Configuration configuration) {
        List<Class<T>> serviceClasses = IterableUtils.toList(ServiceLoaderUtil.loadClasses(clazz, configuration));
        ArrayList<T> results = new ArrayList<T>();
        for (Class<T> serviceClass : serviceClasses) {
            results.add(InjectHelper.getInstance(serviceClass));
        }
        return results;
    }

    public static void shutdown() {
        injector = null;
    }

    public static boolean hasInjector() {
        return injector != null;
    }

    @VisibleForTesting
    public static void setInjector(Injector injector) {
        InjectHelper.injector = injector;
    }

    private static void ensureInjectorCreated(ModuleMaker moduleMaker, Configuration configuration) {
        if (injector == null) {
            injector = Guice.createInjector((Module[])new Module[]{moduleMaker.createModule(), new ObjectMapperModule()});
        }
    }

    public static interface ModuleMaker {
        public Module createModule();

        public Configuration getConfiguration();
    }
}

