/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.cache;

import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.mware.core.cache.CacheOptions;
import com.mware.core.cache.CacheService;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.cache2k.Cache;
import org.cache2k.Cache2kBuilder;

@Singleton
public class InMemoryCacheService
implements CacheService {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Map<String, Cache<?, ?>> caches = new HashMap();

    @Override
    public <T> T put(String cacheName, String key, T t, CacheOptions cacheOptions) {
        return this.write(() -> {
            Cache cache = this.getOrCreateCache(cacheName, cacheOptions);
            cache.put((Object)key, t);
            return t;
        });
    }

    @Override
    public <T> T getIfPresent(String cacheName, String key) {
        return this.read(() -> {
            Cache cache = this.getCache(cacheName);
            if (cache == null) {
                return null;
            }
            return cache.get((Object)key);
        });
    }

    @Override
    public void invalidate(String cacheName) {
        this.write(() -> {
            Cache cache = this.getCache(cacheName);
            if (cache == null) {
                return null;
            }
            cache.clear();
            return null;
        });
    }

    @Override
    public void invalidate(String cacheName, String key) {
        this.write(() -> {
            Cache cache = this.getCache(cacheName);
            if (cache == null) {
                return null;
            }
            cache.remove((Object)key);
            return null;
        });
    }

    private <T> Cache<String, T> getCache(String cacheName) {
        return this.caches.get(cacheName);
    }

    private <T> Cache<String, T> getOrCreateCache(String cacheName, CacheOptions cacheOptions) {
        Cache cache = this.getCache(cacheName);
        if (cache != null) {
            return cache;
        }
        Cache2kBuilder builder = Cache2kBuilder.of(String.class, Object.class);
        if (cacheOptions.getExpireAfterWrite() != null) {
            builder.expireAfterWrite(cacheOptions.getExpireAfterWrite().longValue(), TimeUnit.SECONDS);
        } else {
            builder.eternal(true);
        }
        if (cacheOptions.getMaximumSize() != null) {
            builder.entryCapacity(cacheOptions.getMaximumSize().longValue());
        }
        cache = builder.build();
        this.caches.put(cacheName, cache);
        return cache;
    }

    private <T> T write(Provider<T> provider) {
        this.readWriteLock.writeLock().lock();
        try {
            Object object = provider.get();
            return (T)object;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private <T> T read(Provider<T> provider) {
        this.readWriteLock.readLock().lock();
        try {
            Object object = provider.get();
            return (T)object;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }
}

