/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.cmdline;

import com.beust.jcommander.Parameters;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.mware.core.cmdline.CommandLineTool;
import com.mware.core.exception.BcException;
import com.mware.core.util.ServiceLoaderUtil;
import com.mware.ge.util.IterableUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Cli
extends CommandLineTool {
    @Override
    public int run(String[] args, boolean initFramework) throws Exception {
        List<Class<? extends CommandLineTool>> commandLineToolClasses = IterableUtils.toList(this.findCommandLineToolClasses());
        if (args.length == 0) {
            this.printHelp(commandLineToolClasses, "Require tools classname");
            return -1;
        }
        String className = args[0];
        String[] remainingOfArgs = Arrays.copyOfRange(args, 1, args.length);
        Class<? extends CommandLineTool> clazz = this.findToolClass(commandLineToolClasses, className);
        if (clazz == null) {
            return -1;
        }
        Method mainMethod = clazz.getMethod("main", String[].class);
        mainMethod.invoke(null, new Object[]{remainingOfArgs});
        return 0;
    }

    private void printHelp(List<Class<? extends CommandLineTool>> commandLineToolClasses, String message) {
        System.err.println(message);
        Collections.sort(commandLineToolClasses, new Comparator<Class<? extends CommandLineTool>>(){

            @Override
            public int compare(Class<? extends CommandLineTool> o1, Class<? extends CommandLineTool> o2) {
                return o1.getSimpleName().compareTo(o2.getSimpleName());
            }
        });
        int maxLength = (Integer)Ordering.natural().max(Iterables.transform(commandLineToolClasses, (Function)new Function<Class<? extends CommandLineTool>, Integer>(){

            public Integer apply(Class<? extends CommandLineTool> input) {
                return input.getSimpleName().length();
            }
        }));
        for (Class<? extends CommandLineTool> commandLineToolClass : commandLineToolClasses) {
            String description = this.getDescription(commandLineToolClass);
            System.err.println(String.format("  %-" + maxLength + "s  %s", commandLineToolClass.getSimpleName(), description));
        }
    }

    private String getDescription(Class<? extends CommandLineTool> commandLineToolClass) {
        Parameters parameters = commandLineToolClass.getAnnotation(Parameters.class);
        if (parameters == null) {
            return "";
        }
        return parameters.commandDescription();
    }

    @Override
    protected int run() throws Exception {
        throw new BcException("This run should not be called.");
    }

    private Iterable<Class<? extends CommandLineTool>> findCommandLineToolClasses() {
        return ServiceLoaderUtil.loadClasses(CommandLineTool.class, this.getConfiguration());
    }

    private Class<? extends CommandLineTool> findToolClass(List<Class<? extends CommandLineTool>> commandLineToolClasses, String classname) {
        for (Class<? extends CommandLineTool> commandLineToolClass : commandLineToolClasses) {
            if (!commandLineToolClass.getName().equalsIgnoreCase(classname) && !commandLineToolClass.getSimpleName().equalsIgnoreCase(classname)) continue;
            return commandLineToolClass;
        }
        try {
            return Class.forName(classname).asSubclass(CommandLineTool.class);
        }
        catch (ClassNotFoundException e) {
            this.printHelp(commandLineToolClasses, "Could not find command line tool: " + classname);
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        CommandLineTool.main(new Cli(), args, false);
    }
}

