/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.cmdline;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.google.inject.Inject;
import com.mware.core.bootstrap.BcBootstrap;
import com.mware.core.bootstrap.InjectHelper;
import com.mware.core.config.Configuration;
import com.mware.core.config.ConfigurationLoader;
import com.mware.core.lifecycle.LifeSupportService;
import com.mware.core.model.lock.LockRepository;
import com.mware.core.model.role.AuthorizationRepository;
import com.mware.core.model.schema.SchemaRepository;
import com.mware.core.model.user.PrivilegeRepository;
import com.mware.core.model.user.UserRepository;
import com.mware.core.model.workQueue.WorkQueueRepository;
import com.mware.core.orm.SimpleOrmSession;
import com.mware.core.security.VisibilityTranslator;
import com.mware.core.trace.TraceRepository;
import com.mware.core.user.User;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.core.util.VersionUtil;
import com.mware.ge.Authorizations;
import com.mware.ge.Graph;

public abstract class CommandLineTool {
    public static final String THREAD_NAME = "BigConnect CLI";
    protected BcLogger LOGGER;
    public static final boolean DEFAULT_INIT_FRAMEWORK = true;
    protected Configuration configuration;
    protected boolean willExit = false;
    protected UserRepository userRepository;
    protected AuthorizationRepository authorizationRepository;
    protected Authorizations authorizations;
    protected PrivilegeRepository privilegeRepository;
    protected LockRepository lockRepository;
    protected User user;
    protected Graph graph;
    protected WorkQueueRepository workQueueRepository;
    protected SchemaRepository schemaRepository;
    protected VisibilityTranslator visibilityTranslator;
    protected SimpleOrmSession simpleOrmSession;
    protected LifeSupportService lifeSupportService;
    protected JCommander jCommander;
    protected boolean frameworkInitialized;
    @Parameter(names={"--help", "-h"}, description="Print help", help=true)
    private boolean help;
    @Parameter(names={"--version"}, description="Print version")
    private boolean version;

    public int run(String[] args) throws Exception {
        return this.run(args, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int run(String[] args, boolean initFramework) throws Exception {
        try {
            block13: {
                this.LOGGER = BcLoggerFactory.getLogger(CommandLineTool.class, "cli");
                final Thread mainThread = Thread.currentThread();
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        CommandLineTool.this.willExit = true;
                        try {
                            mainThread.join(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
                try {
                    this.jCommander = this.parseArguments(args);
                    if (this.jCommander == null) {
                        int n = -1;
                        return n;
                    }
                    if (this.help) {
                        this.printHelp(this.jCommander);
                        int n = -1;
                        return n;
                    }
                    if (!this.version) break block13;
                }
                catch (ParameterException ex) {
                    System.err.println(ex.getMessage());
                    int n = -1;
                    return n;
                }
                VersionUtil.printVersion();
                int n = -1;
                return n;
            }
            if (initFramework) {
                this.initializeFramework();
            }
            int result = -1;
            result = this.run();
            this.LOGGER.debug("command result: %d", result);
            int n = result;
            return n;
        }
        finally {
            if (this.frameworkInitialized) {
                this.shutdown();
            }
        }
    }

    protected void initializeFramework() {
        InjectHelper.inject(this, BcBootstrap.bootstrapModuleMaker(this.getConfiguration()), this.getConfiguration());
        if (this.configuration.getBoolean("trace.enabled", false)) {
            TraceRepository traceRepository = InjectHelper.getInstance(TraceRepository.class);
            traceRepository.enable();
        }
        InjectHelper.getInstance(SchemaRepository.class);
        this.frameworkInitialized = true;
    }

    protected void printHelp(JCommander j) {
        j.usage();
    }

    protected JCommander parseArguments(String[] args) {
        return new JCommander((Object)this, args);
    }

    protected void shutdown() {
        this.getLifeSupportService().shutdown();
    }

    protected abstract int run() throws Exception;

    protected Configuration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = ConfigurationLoader.load();
        }
        return this.configuration;
    }

    protected User getUser() {
        if (this.user == null) {
            this.user = this.userRepository.getSystemUser();
        }
        return this.user;
    }

    protected Authorizations getAuthorizations() {
        if (this.authorizations == null) {
            this.authorizations = this.getAuthorizationRepository().getGraphAuthorizations(this.getUser(), new String[0]);
        }
        return this.authorizations;
    }

    protected boolean willExit() {
        return this.willExit;
    }

    @Inject
    public void setLockRepository(LockRepository lockRepository) {
        this.lockRepository = lockRepository;
    }

    @Inject
    public final void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @Inject
    public void setAuthorizationRepository(AuthorizationRepository authorizationRepository) {
        this.authorizationRepository = authorizationRepository;
    }

    @Inject
    public void setPrivilegeRepository(PrivilegeRepository privilegeRepository) {
        this.privilegeRepository = privilegeRepository;
    }

    @Inject
    public final void setGraph(Graph graph) {
        this.graph = graph;
    }

    @Inject
    public final void setWorkQueueRepository(WorkQueueRepository workQueueRepository) {
        this.workQueueRepository = workQueueRepository;
    }

    @Inject
    public final void setSchemaRepository(SchemaRepository schemaRepository) {
        this.schemaRepository = schemaRepository;
    }

    @Inject
    public final void setSimpleOrmSession(SimpleOrmSession simpleOrmSession) {
        this.simpleOrmSession = simpleOrmSession;
    }

    @Inject
    public void setLifeSupportService(LifeSupportService lifeSupportService) {
        this.lifeSupportService = lifeSupportService;
    }

    public SimpleOrmSession getSimpleOrmSession() {
        return this.simpleOrmSession;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public WorkQueueRepository getWorkQueueRepository() {
        return this.workQueueRepository;
    }

    public UserRepository getUserRepository() {
        return this.userRepository;
    }

    public AuthorizationRepository getAuthorizationRepository() {
        return this.authorizationRepository;
    }

    public PrivilegeRepository getPrivilegeRepository() {
        return this.privilegeRepository;
    }

    public SchemaRepository getSchemaRepository() {
        return this.schemaRepository;
    }

    public VisibilityTranslator getVisibilityTranslator() {
        return this.visibilityTranslator;
    }

    public LifeSupportService getLifeSupportService() {
        return this.lifeSupportService;
    }

    @Inject
    public void setVisibilityTranslator(VisibilityTranslator visibilityTranslator) {
        this.visibilityTranslator = visibilityTranslator;
    }

    public static void main(CommandLineTool commandLineTool, String[] args, boolean initFramework) throws Exception {
        int res = commandLineTool.run(args, initFramework);
        if (res != 0) {
            System.exit(res);
        }
    }

    public static void main(CommandLineTool commandLineTool, String[] args) throws Exception {
        Thread.currentThread().setName(THREAD_NAME);
        CommandLineTool.main(commandLineTool, args, true);
    }
}

