/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.config;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mware.core.config.Configuration;
import com.mware.core.config.ConfigurationLoader;
import com.mware.core.exception.BcException;
import com.mware.core.exception.BcResourceNotFoundException;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.core.util.ProcessUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;

public class FileConfigurationLoader
extends ConfigurationLoader {
    public static final String ENV_BC_DIR = "BIGCONNECT_DIR";
    public static final String DEFAULT_UNIX_LOCATION = "/opt/bigconnect/";
    public static final String DEFAULT_WINDOWS_LOCATION = "/opt/bigconnect/";
    public static final String ENV_SEARCH_LOCATIONS = "BC_CONFIGURATION_LOADER_SEARCH_LOCATIONS";
    public static final String ENV_SEARCH_LOCATIONS_DEFAULT = Joiner.on((String)",").join((Object[])new String[]{SearchLocation.SystemProperty.getValue(), SearchLocation.EnvironmentVariable.getValue(), SearchLocation.UserHome.getValue(), SearchLocation.AppData.getValue(), SearchLocation.BcDefaultDirectory.getValue()});

    public FileConfigurationLoader(Map initParameters) {
        super(initParameters);
    }

    @Override
    public Configuration createConfiguration() {
        Map<String, String> properties = this.getDefaultProperties();
        List<File> configDirectories = FileConfigurationLoader.getBcDirectoriesFromLeastPriority("config");
        if (configDirectories.size() == 0) {
            throw new BcException("Could not find any valid config directories.");
        }
        ArrayList<String> loadedFiles = new ArrayList<String>();
        for (File directory : configDirectories) {
            Map<String, String> directoryProperties = FileConfigurationLoader.loadDirectory(directory, loadedFiles);
            properties.putAll(directoryProperties);
        }
        this.setConfigurationInfo("loadedFiles", loadedFiles);
        return new Configuration(this, properties);
    }

    private Map<String, String> getDefaultProperties() {
        HashMap<String, String> defaultProperties = new HashMap<String, String>(this.getInitParameters());
        List<File> configDirs = FileConfigurationLoader.getBcDirectoriesFromMostPriority("config");
        if (configDirs.size() > 0) {
            String bcDir = configDirs.get(0).getParentFile().getAbsolutePath();
            defaultProperties.put(ENV_BC_DIR, bcDir);
        }
        defaultProperties.putAll(System.getenv());
        return defaultProperties;
    }

    public static List<File> getBcDirectoriesFromMostPriority(String subDirectory) {
        ArrayList<File> results = new ArrayList<File>();
        List<SearchLocation> searchLocations = FileConfigurationLoader.getSearchLocations();
        block7: for (SearchLocation searchLocation : searchLocations) {
            switch (searchLocation) {
                case AppData: {
                    String appData = System.getProperty("appdata");
                    if (appData == null || appData.length() <= 0) continue block7;
                    FileConfigurationLoader.addBcSubDirectory(results, new File(new File(appData), "bigconnect").getAbsolutePath(), subDirectory);
                    continue block7;
                }
                case EnvironmentVariable: {
                    FileConfigurationLoader.addBcSubDirectory(results, System.getenv(ENV_BC_DIR), subDirectory);
                    continue block7;
                }
                case SystemProperty: {
                    FileConfigurationLoader.addBcSubDirectory(results, System.getProperty(ENV_BC_DIR, null), subDirectory);
                    continue block7;
                }
                case UserHome: {
                    String userHome = System.getProperty("user.home");
                    if (userHome == null || userHome.length() <= 0) continue block7;
                    FileConfigurationLoader.addBcSubDirectory(results, new File(new File(userHome), ".bigconnect").getAbsolutePath(), subDirectory);
                    continue block7;
                }
                case BcDefaultDirectory: {
                    String defaultBcDir = FileConfigurationLoader.getDefaultBcDir();
                    FileConfigurationLoader.addBcSubDirectory(results, defaultBcDir, subDirectory);
                    continue block7;
                }
            }
            throw new BcException("Unhandled search type: " + (Object)((Object)searchLocation));
        }
        return ImmutableList.copyOf(results);
    }

    public static List<File> getBcDirectoriesFromLeastPriority(String subDirectory) {
        return Lists.reverse(FileConfigurationLoader.getBcDirectoriesFromMostPriority(subDirectory));
    }

    private static List<SearchLocation> getSearchLocations() {
        String locationsString = System.getProperty(ENV_SEARCH_LOCATIONS);
        if (locationsString == null && (locationsString = System.getenv(ENV_SEARCH_LOCATIONS)) == null) {
            locationsString = ENV_SEARCH_LOCATIONS_DEFAULT;
        }
        String[] locationItems = locationsString.split(",");
        ArrayList<SearchLocation> searchLocations = new ArrayList<SearchLocation>();
        for (String locationItem : locationItems) {
            searchLocations.add(SearchLocation.parse(locationItem));
        }
        return searchLocations;
    }

    public static String getDefaultBcDir() {
        String _location = null;
        _location = ProcessUtil.isWindows() ? "/opt/bigconnect/" : "/opt/bigconnect/";
        File f = new File(_location);
        if (!f.exists()) {
            _location = System.getProperty("catalina.base") + "\\bc-conf";
        }
        return _location;
    }

    private static void addBcSubDirectory(List<File> results, String location, String subDirectory) {
        File dir;
        if (location == null || location.trim().length() == 0) {
            return;
        }
        if ((location = location.trim()).startsWith("file://")) {
            location = location.substring("file://".length());
        }
        if (!(dir = new File(new File(location), subDirectory)).exists()) {
            return;
        }
        results.add(dir);
    }

    private static Map<String, String> loadDirectory(File configDirectory, List<String> loadedFiles) {
        BcLogger LOGGER = BcLoggerFactory.getLogger(FileConfigurationLoader.class);
        LOGGER.debug("Attempting to load configuration from directory: %s", configDirectory);
        if (!configDirectory.exists()) {
            throw new BcException("Could not find config directory: " + configDirectory);
        }
        File[] files = configDirectory.listFiles();
        if (files == null) {
            throw new BcException("Could not parse directory name: " + configDirectory);
        }
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return this.getComparableFileName(o1).compareTo(this.getComparableFileName(o2));
            }

            private String getComparableFileName(File o1) {
                return FilenameUtils.getBaseName((String)o1.getName()).toLowerCase();
            }
        });
        HashMap<String, String> properties = new HashMap<String, String>();
        for (File f : files) {
            if (!f.getAbsolutePath().endsWith(".properties")) continue;
            try {
                Map<String, String> fileProperties = FileConfigurationLoader.loadFile(f.getAbsolutePath(), loadedFiles);
                for (Map.Entry<String, String> filePropertyEntry : fileProperties.entrySet()) {
                    properties.put(filePropertyEntry.getKey(), filePropertyEntry.getValue());
                }
            }
            catch (IOException ex) {
                throw new BcException("Could not load config file: " + f.getAbsolutePath(), ex);
            }
        }
        return properties;
    }

    private static Map<String, String> loadFile(String fileName, List<String> loadedFiles) throws IOException {
        BcLogger LOGGER = BcLoggerFactory.getLogger(FileConfigurationLoader.class);
        HashMap<String, String> results = new HashMap<String, String>();
        LOGGER.info("Loading config file: %s", fileName);
        try (FileInputStream in = new FileInputStream(fileName);){
            Properties properties = new Properties();
            properties.load(in);
            for (Map.Entry<Object, Object> prop : properties.entrySet()) {
                String key = prop.getKey().toString();
                String value = prop.getValue().toString();
                results.put(key, value);
            }
            loadedFiles.add(fileName);
        }
        catch (Exception e) {
            LOGGER.info("Could not load configuration file: %s", fileName);
        }
        return results;
    }

    @Override
    public File resolveFileName(String fileName) {
        return FileConfigurationLoader.resolveLocalFileName(fileName);
    }

    public static File resolveLocalFileName(String fileName) {
        List<File> configDirectories = FileConfigurationLoader.getBcDirectoriesFromMostPriority("config");
        if (configDirectories.size() == 0) {
            throw new BcResourceNotFoundException("Could not find any valid config directories.");
        }
        for (File directory : configDirectories) {
            File f = new File(directory, fileName);
            if (!f.exists()) continue;
            return f;
        }
        throw new BcResourceNotFoundException("Could not find file: " + fileName);
    }

    public static enum SearchLocation {
        BcDefaultDirectory("defaultDir"),
        AppData("appdata"),
        UserHome("userHome"),
        EnvironmentVariable("env"),
        SystemProperty("systemProperty");

        private final String value;

        private SearchLocation(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getValue();
        }

        public static SearchLocation parse(String searchType) {
            for (SearchLocation type : SearchLocation.values()) {
                if (!type.name().equalsIgnoreCase(searchType) && !type.getValue().equalsIgnoreCase(searchType)) continue;
                return type;
            }
            throw new BcException("Could not parse search type: " + searchType);
        }
    }
}

