/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.config;

import com.mware.core.config.Configuration;
import com.mware.core.config.ConfigurationLoader;
import com.mware.core.config.FileConfigurationLoader;
import com.mware.core.exception.BcException;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;

public class HashMapConfigurationLoader
extends ConfigurationLoader {
    public HashMapConfigurationLoader(String propertiesString) {
        this(HashMapConfigurationLoader.parseStringToProperties(propertiesString));
    }

    public HashMapConfigurationLoader(Map initParameters) {
        super(initParameters);
    }

    @Override
    public Configuration createConfiguration() {
        return new Configuration(this, this.getInitParameters());
    }

    @Override
    public File resolveFileName(String fileName) {
        return FileConfigurationLoader.resolveLocalFileName(fileName);
    }

    private static Properties parseStringToProperties(String propertiesString) {
        Properties properties = new Properties();
        StringReader reader = new StringReader(propertiesString);
        try {
            properties.load(reader);
        }
        catch (IOException ex) {
            throw new BcException("Could not load properties string", ex);
        }
        return properties;
    }
}

