/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.email;

import com.google.common.base.Joiner;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mware.core.config.Configuration;
import com.mware.core.email.EmailRepository;
import com.mware.core.email.SmtpEmailConfiguration;
import com.mware.core.exception.BcException;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

@Singleton
public class SmtpEmailRepository
implements EmailRepository {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(SmtpEmailRepository.class);
    private static final String CHARSET = "UTF-8";
    private SmtpEmailConfiguration smtpEmailConfiguration = new SmtpEmailConfiguration();

    @Inject
    public SmtpEmailRepository(Configuration configuration) {
        configuration.setConfigurables(this.smtpEmailConfiguration, "repository.email.smtp");
    }

    @Override
    public void send(String fromAddress, String toAddress, String subject, String body) {
        this.send(fromAddress, new String[]{toAddress}, subject, body);
    }

    @Override
    public void send(String fromAddress, String[] toAddresses, String subject, String body) {
        String joinedToAddresses = Joiner.on((String)",").join((Object[])toAddresses);
        LOGGER.debug("sending SMTP email from: \"%s\", to: \"%s\", subject: \"%s\"", fromAddress, joinedToAddresses, subject);
        LOGGER.debug("sending SMTP email body:%n%s", body);
        try {
            MimeMessage mimeMessage = new MimeMessage(this.getSession());
            mimeMessage.setFrom((Address)InternetAddress.parse((String)fromAddress)[0]);
            mimeMessage.setSubject(subject, CHARSET);
            if (body.startsWith("<html>")) {
                MimeMultipart multipart = new MimeMultipart();
                MimeBodyPart html = new MimeBodyPart();
                String contentType = "text/html; charset=UTF-8";
                html.setHeader("Content-Type", contentType);
                html.setContent((Object)body, contentType);
                multipart.addBodyPart((BodyPart)html);
                mimeMessage.setContent((Multipart)multipart);
            } else {
                mimeMessage.setText(body, CHARSET);
            }
            mimeMessage.setSentDate(new Date());
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)joinedToAddresses));
            Transport.send((Message)mimeMessage);
        }
        catch (MessagingException me) {
            throw new BcException("exception while sending email", me);
        }
    }

    @Override
    public Session getSession() {
        Properties properties = new Properties();
        properties.put("mail.smtp.host", this.smtpEmailConfiguration.getServerHostname());
        properties.put("mail.smtp.port", (Object)this.smtpEmailConfiguration.getServerPort());
        Authenticator authenticator = null;
        switch (this.smtpEmailConfiguration.getServerAuthentication()) {
            case NONE: {
                break;
            }
            case TLS: {
                properties.put("mail.smtp.auth", "true");
                properties.put("mail.smtp.starttls.enable", "true");
                authenticator = this.getAuthenticator();
                break;
            }
            case SSL: {
                properties.put("mail.smtp.auth", "true");
                properties.put("mail.smtp.socketFactory.port", (Object)this.smtpEmailConfiguration.getServerPort());
                properties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                authenticator = this.getAuthenticator();
                break;
            }
            default: {
                throw new BcException("unexpected MailServerAuthentication: " + this.smtpEmailConfiguration.getServerAuthentication().toString());
            }
        }
        Session session = Session.getDefaultInstance((Properties)properties, authenticator);
        if (LOGGER.isTraceEnabled()) {
            session.setDebugOut((PrintStream)new LoggerPrintStream(LOGGER));
            session.setDebug(true);
        }
        return session;
    }

    private Authenticator getAuthenticator() {
        return new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(SmtpEmailRepository.this.smtpEmailConfiguration.getServerUsername(), SmtpEmailRepository.this.smtpEmailConfiguration.getServerPassword());
            }
        };
    }

    private class LoggerPrintStream
    extends PrintStream {
        public LoggerPrintStream(final BcLogger logger) {
            super(new OutputStream(){
                private final int NEWLINE = "\n".getBytes()[0];
                private final StringWriter buffer = new StringWriter();

                @Override
                public void write(int c) throws IOException {
                    if (c == this.NEWLINE) {
                        logger.trace(this.buffer.toString(), new Object[0]);
                        this.buffer.getBuffer().setLength(0);
                    } else {
                        this.buffer.write(c);
                    }
                }
            });
        }
    }
}

