/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.exception;

import com.mware.core.bootstrap.InjectHelper;
import com.mware.core.exception.BcException;
import com.mware.core.security.AuditService;
import com.mware.core.user.User;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;

public class BcAccessDeniedException
extends BcException {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(BcAccessDeniedException.class);
    private static AuditService auditService;
    private final User user;
    private final Object resourceId;

    public BcAccessDeniedException(String message, User user, Object resourceId) {
        super(message);
        this.user = user;
        this.resourceId = resourceId;
        try {
            AuditService auditService = this.getAuditService();
            auditService.auditAccessDenied(message, user, resourceId);
        }
        catch (Exception ex) {
            LOGGER.debug("failed to audit access denied \"%s\" (userId: %s, resourceId: %s)", message, user == null ? "unknown" : user.getUserId(), resourceId, ex);
        }
    }

    private AuditService getAuditService() {
        if (auditService == null) {
            auditService = InjectHelper.getInstance(AuditService.class);
        }
        return auditService;
    }

    public User getUser() {
        return this.user;
    }

    public Object getResourceId() {
        return this.resourceId;
    }
}

