/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.externalResource;

import com.mware.core.bootstrap.InjectHelper;
import com.mware.core.config.Configuration;
import com.mware.core.externalResource.ExternalResourceWorker;
import com.mware.core.status.MetricEntry;
import com.mware.core.status.StatusRepository;
import com.mware.core.status.StatusServer;
import com.mware.core.status.model.ExternalResourceRunnerStatus;
import com.mware.core.status.model.Status;
import com.mware.core.user.User;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExternalResourceRunner {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(ExternalResourceRunner.class);
    private final Configuration config;
    private final User user;
    private final StatusRepository statusRepository;
    private List<RunningWorker> runningWorkers = new ArrayList<RunningWorker>();
    private StatusServer statusServer = null;

    public ExternalResourceRunner(Configuration config, StatusRepository statusRepository, User user) {
        this.config = config;
        this.statusRepository = statusRepository;
        this.user = user;
    }

    public void startAllAndWait() {
        Collection<RunningWorker> runningWorkers = this.startAll();
        while (runningWorkers.size() > 0) {
            for (RunningWorker runningWorker : runningWorkers) {
                if (!runningWorker.getThread().isAlive()) {
                    LOGGER.error("found a dead thread: " + runningWorker.getThread().getName(), new Object[0]);
                    return;
                }
                try {
                    runningWorker.getThread().join(1000L);
                }
                catch (InterruptedException e) {
                    LOGGER.error("join interrupted", e);
                    return;
                }
            }
        }
    }

    public Collection<RunningWorker> startAll() {
        this.runningWorkers = new ArrayList<RunningWorker>();
        if (this.config.getBoolean("status.enabled", true)) {
            this.statusServer = this.startStatusServer(this.runningWorkers);
        }
        Collection<ExternalResourceWorker> workers = InjectHelper.getInjectedServices(ExternalResourceWorker.class, this.config);
        for (ExternalResourceWorker worker : workers) {
            this.runningWorkers.add(this.start(worker, this.user));
        }
        return this.runningWorkers;
    }

    private StatusServer startStatusServer(final List<RunningWorker> runningWorkers) {
        return new StatusServer(this.config, this.statusRepository, "externalResource", ExternalResourceRunner.class){

            @Override
            protected ExternalResourceRunnerStatus createStatus() {
                ExternalResourceRunnerStatus status = new ExternalResourceRunnerStatus();
                for (RunningWorker runningWorker : runningWorkers) {
                    status.getRunningWorkers().add(runningWorker.getStatus());
                }
                return status;
            }
        };
    }

    private RunningWorker start(ExternalResourceWorker worker, User user) {
        worker.prepare(user);
        Thread t = new Thread(() -> {
            try {
                worker.run();
            }
            catch (Throwable ex) {
                LOGGER.error("Failed running external resource worker: " + worker.getClass().getName(), ex);
            }
        });
        t.setName("external-resource-worker-" + worker.getClass().getSimpleName() + "-" + t.getId());
        t.setDaemon(true);
        LOGGER.debug("starting external resource worker thread: %s", t.getName());
        t.start();
        return new RunningWorker(worker, t);
    }

    public void shutdown() {
        LOGGER.debug("Stopping ExternalResourceRunner...", new Object[0]);
        for (RunningWorker worker : this.runningWorkers) {
            worker.shutdown();
        }
        if (this.statusServer != null) {
            this.statusServer.shutdown();
        }
        LOGGER.debug("Stopped ExternalResourceRunner", new Object[0]);
    }

    public static class RunningWorker {
        private final ExternalResourceWorker worker;
        private final Thread thread;

        public RunningWorker(ExternalResourceWorker worker, Thread thread) {
            this.worker = worker;
            this.thread = thread;
        }

        public ExternalResourceWorker getWorker() {
            return this.worker;
        }

        public Thread getThread() {
            return this.thread;
        }

        public ExternalResourceRunnerStatus.ExternalResourceWorkerStatus getStatus() {
            ExternalResourceRunnerStatus.ExternalResourceWorkerStatus status = new ExternalResourceRunnerStatus.ExternalResourceWorkerStatus();
            StatusServer.getGeneralInfo(status, this.getWorker().getClass());
            status.setThreadName(this.getThread().getName());
            for (MetricEntry metric : this.getWorker().getMetrics()) {
                status.getMetrics().put(metric.getName(), Status.Metric.create(metric.getMetric()));
            }
            return status;
        }

        public void shutdown() {
            this.worker.stop();
        }
    }
}

