/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.ingest;

import com.google.common.base.Preconditions;
import com.mware.core.ingest.dataworker.DataWorker;
import com.mware.core.ingest.dataworker.DataWorkerData;
import com.mware.core.ingest.dataworker.ElementOrPropertyStatus;
import com.mware.core.model.Description;
import com.mware.core.model.Name;
import com.mware.core.model.clientapi.dto.VisibilityJson;
import com.mware.core.model.properties.BcSchema;
import com.mware.ge.Element;
import com.mware.ge.Metadata;
import com.mware.ge.Property;
import com.mware.ge.Visibility;
import com.mware.ge.values.storable.StreamingPropertyValue;
import com.mware.ge.values.storable.Values;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;

@Name(value="Metadata Processor")
@Description(value="Adds properties to a vertex from a metadata JSON document")
public class MetadataDataWorker
extends DataWorker {
    @Override
    public void execute(InputStream in, DataWorkerData data) throws Exception {
        JSONObject propertyJson;
        int i;
        JSONObject metadataJson = this.getMetadataJson(data);
        JSONArray propertiesJson = metadataJson.optJSONArray("properties");
        if (propertiesJson == null) {
            return;
        }
        for (i = 0; i < propertiesJson.length(); ++i) {
            propertyJson = propertiesJson.getJSONObject(i);
            this.setProperty(propertyJson, data);
        }
        this.getGraph().flush();
        for (i = 0; i < propertiesJson.length(); ++i) {
            propertyJson = propertiesJson.getJSONObject(i);
            this.queueProperty(propertyJson, data);
        }
    }

    public void queueProperty(JSONObject propertyJson, DataWorkerData data) {
        String propertyKey = propertyJson.optString("key");
        if (propertyKey == null) {
            propertyKey = "";
        }
        String propertyName = propertyJson.optString("name");
        if (this.getWebQueueRepository().shouldBroadcastGraphPropertyChange(propertyName, data.getPriority())) {
            this.getWebQueueRepository().broadcastPropertyChange(data.getElement(), propertyKey, propertyName, null);
        }
        this.getWorkQueueRepository().pushGraphPropertyQueue(data.getElement(), propertyKey, propertyName, null, null, data.getPriority(), ElementOrPropertyStatus.UPDATE, null);
    }

    private void setProperty(JSONObject propertyJson, DataWorkerData data) {
        String propertyKey = propertyJson.optString("key", null);
        if (propertyKey == null) {
            propertyKey = "";
        }
        String propertyName = propertyJson.optString("name", null);
        Preconditions.checkNotNull((Object)propertyName, (Object)("name is required: " + propertyJson.toString()));
        String propertyValue = propertyJson.optString("value", null);
        Preconditions.checkNotNull((Object)propertyValue, (Object)("value is required: " + propertyJson.toString()));
        String visibilitySource = propertyJson.optString("visibilitySource", null);
        Visibility visibility = visibilitySource == null ? data.getVisibility() : this.getVisibilityTranslator().toVisibility(visibilitySource).getVisibility();
        Metadata metadata = Metadata.create();
        BcSchema.VISIBILITY_JSON_METADATA.setMetadata(metadata, VisibilityJson.updateVisibilitySource(null, visibilitySource), this.getVisibilityTranslator().getDefaultVisibility());
        data.getElement().addPropertyValue(propertyKey, propertyName, Values.stringValue(propertyValue), metadata, visibility, this.getAuthorizations());
    }

    public JSONObject getMetadataJson(DataWorkerData data) throws IOException {
        StreamingPropertyValue metadataJsonValue = (StreamingPropertyValue)BcSchema.METADATA_JSON.getPropertyValue(data.getElement());
        try (InputStream metadataJsonIn = metadataJsonValue.getInputStream();){
            String metadataJsonString = IOUtils.toString((InputStream)metadataJsonIn);
            JSONObject jSONObject = new JSONObject(metadataJsonString);
            return jSONObject;
        }
    }

    @Override
    public boolean isHandled(Element element, Property property) {
        if (property != null) {
            return false;
        }
        StreamingPropertyValue mappingJson = (StreamingPropertyValue)BcSchema.METADATA_JSON.getPropertyValue(element);
        return mappingJson != null;
    }
}

