/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.ingest;

import com.mware.core.ingest.FileImportSupportingFileHandler;
import com.mware.core.model.Description;
import com.mware.core.model.Name;
import com.mware.core.model.properties.BcSchema;
import com.mware.ge.VertexBuilder;
import com.mware.ge.Visibility;
import com.mware.ge.values.storable.ByteArray;
import com.mware.ge.values.storable.DefaultStreamingPropertyValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

@Name(value="Metadata Import")
@Description(value="Imports a .metadata.json file and assigns it to a metadata JSON property on that vertex")
public class MetadataFileImportSupportingFileHandler
extends FileImportSupportingFileHandler {
    private static final String METADATA_JSON_FILE_NAME_SUFFIX = ".metadata.json";

    @Override
    public boolean isSupportingFile(File f) {
        return f.getName().endsWith(METADATA_JSON_FILE_NAME_SUFFIX);
    }

    @Override
    public FileImportSupportingFileHandler.AddSupportingFilesResult addSupportingFiles(VertexBuilder vertexBuilder, File f, Visibility visibility) throws FileNotFoundException {
        File mappingJsonFile = MetadataFileImportSupportingFileHandler.getMetadataFile(f);
        if (mappingJsonFile.exists()) {
            final FileInputStream mappingJsonInputStream = new FileInputStream(mappingJsonFile);
            DefaultStreamingPropertyValue mappingJsonValue = new DefaultStreamingPropertyValue(mappingJsonInputStream, ByteArray.class);
            mappingJsonValue.searchIndex(false);
            BcSchema.METADATA_JSON.setProperty(vertexBuilder, mappingJsonValue, visibility);
            return new FileImportSupportingFileHandler.AddSupportingFilesResult(){

                @Override
                public void close() throws IOException {
                    mappingJsonInputStream.close();
                }
            };
        }
        return null;
    }

    public static File getMetadataFile(File f) {
        return new File(f.getParentFile(), f.getName() + METADATA_JSON_FILE_NAME_SUFFIX);
    }
}

