/*
 * Decompiled with CFR 0.152.
 */
package com.mware.core.ingest.dataworker;

import com.google.inject.Inject;
import com.mware.core.config.Configuration;
import com.mware.core.exception.BcException;
import com.mware.core.ingest.dataworker.DataWorkerData;
import com.mware.core.ingest.dataworker.DataWorkerPrepareData;
import com.mware.core.ingest.dataworker.ElementOrPropertyStatus;
import com.mware.core.ingest.dataworker.TermMentionFilter;
import com.mware.core.ingest.dataworker.VerifyResults;
import com.mware.core.ingest.video.VideoTranscript;
import com.mware.core.model.graph.GraphRepository;
import com.mware.core.model.properties.BcSchema;
import com.mware.core.model.properties.MediaBcSchema;
import com.mware.core.model.properties.types.BcPropertyUpdate;
import com.mware.core.model.schema.SchemaRepository;
import com.mware.core.model.user.GraphAuthorizationRepository;
import com.mware.core.model.workQueue.Priority;
import com.mware.core.model.workQueue.WebQueueRepository;
import com.mware.core.model.workQueue.WorkQueueRepository;
import com.mware.core.model.workspace.WorkspaceRepository;
import com.mware.core.security.VisibilityTranslator;
import com.mware.core.user.User;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.ge.Authorizations;
import com.mware.ge.Edge;
import com.mware.ge.Element;
import com.mware.ge.Graph;
import com.mware.ge.Metadata;
import com.mware.ge.Property;
import com.mware.ge.Vertex;
import com.mware.ge.Visibility;
import com.mware.ge.mutation.ExistingElementMutation;
import com.mware.ge.values.storable.DefaultStreamingPropertyValue;
import com.mware.ge.values.storable.TextValue;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.Values;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public abstract class DataWorker {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(DataWorker.class);
    private Graph graph;
    private VisibilityTranslator visibilityTranslator;
    private WorkQueueRepository workQueueRepository;
    private WebQueueRepository webQueueRepository;
    private SchemaRepository schemaRepository;
    private GraphAuthorizationRepository graphAuthorizationRepository;
    private DataWorkerPrepareData workerPrepareData;
    private Configuration configuration;
    private WorkspaceRepository workspaceRepository;
    private GraphRepository graphRepository;

    public VerifyResults verify() {
        return new VerifyResults();
    }

    public void prepare(DataWorkerPrepareData workerPrepareData) throws Exception {
        this.workerPrepareData = workerPrepareData;
    }

    protected void applyTermMentionFilters(Vertex outVertex, Iterable<Vertex> termMentions) {
        for (TermMentionFilter termMentionFilter : this.workerPrepareData.getTermMentionFilters()) {
            try {
                termMentionFilter.apply(outVertex, termMentions, this.workerPrepareData.getAuthorizations());
            }
            catch (Exception e) {
                LOGGER.error("Could not apply term mention filter", e);
            }
        }
        this.getGraph().flush();
    }

    protected void pushTextUpdated(DataWorkerData data) {
        if (data == null || data.getElement() == null) {
            return;
        }
        this.getWebQueueRepository().pushTextUpdated((String)data.getElement().getId(), data.getPriority());
    }

    public abstract boolean isHandled(Element var1, Property var2);

    public boolean isDeleteHandled(Element element, Property property) {
        return false;
    }

    public boolean isHiddenHandled(Element element, Property property) {
        return false;
    }

    public boolean isUnhiddenHandled(Element element, Property property) {
        return false;
    }

    public abstract void execute(InputStream var1, DataWorkerData var2) throws Exception;

    public Element refresh(Element element) {
        if (element == null) {
            return null;
        }
        if (element instanceof Vertex) {
            return this.getGraph().getVertex((String)element.getId(), this.getAuthorizations());
        }
        if (element instanceof Edge) {
            return this.getGraph().getEdge((String)element.getId(), this.getAuthorizations());
        }
        throw new BcException("Asking to refresh an element of unknown type: " + element.getClass());
    }

    public boolean isLocalFileRequired() {
        return false;
    }

    protected User getUser() {
        return this.workerPrepareData.getUser();
    }

    public Authorizations getAuthorizations() {
        return this.workerPrepareData.getAuthorizations();
    }

    @Inject
    public final void setGraph(Graph graph) {
        this.graph = graph;
    }

    protected Graph getGraph() {
        return this.graph;
    }

    @Inject
    public final void setWorkQueueRepository(WorkQueueRepository workQueueRepository) {
        this.workQueueRepository = workQueueRepository;
    }

    @Inject
    public void setWebQueueRepository(WebQueueRepository webQueueRepository) {
        this.webQueueRepository = webQueueRepository;
    }

    @Inject
    public final void setWorkspaceRepository(WorkspaceRepository workspaceRepository) {
        this.workspaceRepository = workspaceRepository;
    }

    protected WorkspaceRepository getWorkspaceRepository() {
        return this.workspaceRepository;
    }

    protected WorkQueueRepository getWorkQueueRepository() {
        return this.workQueueRepository;
    }

    public WebQueueRepository getWebQueueRepository() {
        return this.webQueueRepository;
    }

    protected SchemaRepository getSchemaRepository() {
        return this.schemaRepository;
    }

    @Inject
    public final void setSchemaRepository(SchemaRepository schemaRepository) {
        this.schemaRepository = schemaRepository;
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    @Inject
    public final void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    protected VisibilityTranslator getVisibilityTranslator() {
        return this.visibilityTranslator;
    }

    @Inject
    public final void setVisibilityTranslator(VisibilityTranslator visibilityTranslator) {
        this.visibilityTranslator = visibilityTranslator;
    }

    @Inject
    public final void setGraphAuthorizationRepository(GraphAuthorizationRepository graphAuthorizationRepository) {
        this.graphAuthorizationRepository = graphAuthorizationRepository;
    }

    protected GraphAuthorizationRepository getGraphAuthorizationRepository() {
        return this.graphAuthorizationRepository;
    }

    public GraphRepository getGraphRepository() {
        return this.graphRepository;
    }

    @Inject
    public final void setGraphRepository(GraphRepository graphRepository) {
        this.graphRepository = graphRepository;
    }

    protected boolean isTextProperty(Property property) {
        if (property == null) {
            return false;
        }
        if (property.getName().equals(BcSchema.RAW.getPropertyName())) {
            return false;
        }
        Value mimeType = property.getMetadata().getValue(BcSchema.MIME_TYPE.getPropertyName());
        return !mimeType.eq(Values.NO_VALUE) && ((TextValue)mimeType).startsWith(Values.stringValue("text"));
    }

    protected static boolean isVertex(Element element) {
        return element instanceof Vertex;
    }

    protected static boolean isConceptType(Element element, String conceptType) {
        if (element instanceof Vertex) {
            Vertex vertex = (Vertex)element;
            String elementConceptType = vertex.getConceptType();
            if (elementConceptType == null) {
                return false;
            }
            return elementConceptType.equals(conceptType);
        }
        return false;
    }

    protected void addVideoTranscriptAsTextPropertiesToMutation(ExistingElementMutation<Vertex> mutation, String propertyKey, VideoTranscript videoTranscript, Metadata metadata, Visibility visibility) {
        BcSchema.MIME_TYPE_METADATA.setMetadata(metadata, "text/plain", this.getVisibilityTranslator().getDefaultVisibility());
        for (VideoTranscript.TimedText entry : videoTranscript.getEntries()) {
            String textPropertyKey = this.getVideoTranscriptTimedTextPropertyKey(propertyKey, entry);
            DefaultStreamingPropertyValue value = new DefaultStreamingPropertyValue(new ByteArrayInputStream(entry.getText().getBytes()), TextValue.class);
            BcSchema.TEXT.addPropertyValue(mutation, textPropertyKey, value, metadata, visibility);
        }
    }

    protected void pushVideoTranscriptTextPropertiesOnWorkQueue(Element element, String propertyKey, VideoTranscript videoTranscript, Priority priority) {
        for (VideoTranscript.TimedText entry : videoTranscript.getEntries()) {
            String textPropertyKey = this.getVideoTranscriptTimedTextPropertyKey(propertyKey, entry);
            if (this.getWebQueueRepository().shouldBroadcast(priority)) {
                this.getWebQueueRepository().broadcastPropertyChange(element, textPropertyKey, BcSchema.TEXT.getPropertyName(), null);
            }
            this.getWorkQueueRepository().pushGraphPropertyQueue(element, textPropertyKey, BcSchema.TEXT.getPropertyName(), null, null, priority, ElementOrPropertyStatus.UPDATE, null);
        }
    }

    private String getVideoTranscriptTimedTextPropertyKey(String propertyKey, VideoTranscript.TimedText entry) {
        String startTime = String.format("%08d", Math.max(0L, entry.getTime().getStart()));
        String endTime = String.format("%08d", Math.max(0L, entry.getTime().getEnd()));
        return propertyKey + '\u001d' + MediaBcSchema.VIDEO_FRAME.getPropertyName() + '\u001d' + startTime + '\u001d' + endTime;
    }

    protected void addVertexToWorkspaceIfNeeded(DataWorkerData data, Vertex vertex) {
        if (data.getWorkspaceId() == null) {
            return;
        }
        this.graph.flush();
        this.getWorkspaceRepository().updateEntityOnWorkspace(data.getWorkspaceId(), (String)vertex.getId(), this.getUser());
    }

    protected void pushChangedPropertiesOnWorkQueue(DataWorkerData data, List<BcPropertyUpdate> changedProperties) {
        this.getWebQueueRepository().broadcastPropertiesChange(data.getElement(), changedProperties, data.getWorkspaceId(), data.getPriority());
        this.getWorkQueueRepository().pushGraphPropertyQueue(data.getElement(), changedProperties, data.getWorkspaceId(), data.getVisibilitySource(), data.getPriority());
    }
}

